/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.crypto;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.io.DecoratingOutputStream;
import zz.org.bouncycastle.crypto.BufferedBlockCipher;
import zz.org.bouncycastle.crypto.InvalidCipherTextException;

@NotThreadSafe
public class CipherOutputStream
extends DecoratingOutputStream {
    @Nullable
    protected BufferedBlockCipher cipher;
    private byte[] cipherOut = new byte[0];

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public CipherOutputStream(@CheckForNull @WillCloseWhenClosed OutputStream out, @CheckForNull BufferedBlockCipher cipher) {
        super(out);
        this.cipher = cipher;
    }

    private void checkOpen() throws IOException {
        if (null == this.cipher) {
            throw new IOException("cipher output stream is not in open state");
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkOpen();
        int cipherLen = this.cipher.getUpdateOutputSize(1);
        byte[] cipherOut = this.cipherOut;
        if (cipherLen > cipherOut.length) {
            this.cipherOut = cipherOut = new byte[cipherLen];
        }
        if ((cipherLen = this.cipher.processByte((byte)b, cipherOut, 0)) > 0) {
            this.delegate.write(cipherOut, 0, cipherLen);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.checkOpen();
        int cipherLen = this.cipher.getUpdateOutputSize(len);
        byte[] cipherOut = this.cipherOut;
        if (cipherLen > cipherOut.length) {
            this.cipherOut = cipherOut = new byte[cipherLen];
        }
        cipherLen = this.cipher.processBytes(buf, off, len, cipherOut, 0);
        this.delegate.write(cipherOut, 0, cipherLen);
    }

    @OverridingMethodsMustInvokeSuper
    protected void finish() throws IOException {
        this.checkOpen();
        int cipherLen = this.cipher.getOutputSize(0);
        byte[] cipherOut = this.cipherOut;
        if (cipherLen > cipherOut.length) {
            this.cipherOut = cipherOut = new byte[cipherLen];
        }
        try {
            cipherLen = this.cipher.doFinal(cipherOut, 0);
        }
        catch (InvalidCipherTextException ex) {
            throw new IOException(ex);
        }
        this.delegate.write(cipherOut, 0, cipherLen);
    }

    @Override
    public void close() throws IOException {
        if (null != this.cipher) {
            this.finish();
            this.cipher = null;
        }
        this.delegate.close();
    }
}

