/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsLockModel;
import zz.de.schlichtherle.truezip.fs.FsLockModelDecoratingController;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsNeedsSyncException;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.FsResourceOpenException;
import zz.de.schlichtherle.truezip.fs.FsSyncController;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncOptions;
import zz.de.schlichtherle.truezip.fs.FsSyncWarningException;
import zz.de.schlichtherle.truezip.io.DecoratingInputStream;
import zz.de.schlichtherle.truezip.io.DecoratingOutputStream;
import zz.de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.ClutchInputSocket;
import zz.de.schlichtherle.truezip.socket.ClutchOutputSocket;
import zz.de.schlichtherle.truezip.socket.DelegatingInputSocket;
import zz.de.schlichtherle.truezip.socket.DelegatingOutputSocket;
import zz.de.schlichtherle.truezip.socket.IOCache;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.JSE7;

@NotThreadSafe
final class FsCacheController
extends FsLockModelDecoratingController<FsController<? extends FsLockModel>> {
    private static final Logger logger = Logger.getLogger(FsCacheController.class.getName(), FsCacheController.class.getName());
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private final IOPool<?> pool;
    private final Map<FsEntryName, EntryCache> caches = new HashMap<FsEntryName, EntryCache>();

    FsCacheController(IOPool<?> pool, FsController<? extends FsLockModel> controller) {
        super(controller);
        this.pool = pool;
        if (null == this.pool) {
            throw new NullPointerException();
        }
    }

    @Override
    public InputSocket<?> getInputSocket(final FsEntryName name, final BitField<FsInputOption> options) {
        class Input
        extends DelegatingInputSocket<Entry> {
            Input() {
            }

            @Override
            protected InputSocket<?> getDelegate() {
                assert (FsCacheController.this.isWriteLockedByCurrentThread());
                EntryCache cache = (EntryCache)FsCacheController.this.caches.get(name);
                if (null == cache) {
                    if (!options.get(FsInputOption.CACHE)) {
                        return FsCacheController.this.delegate.getInputSocket(name, options);
                    }
                    cache = new EntryCache(name);
                }
                return cache.getInputSocket(options);
            }
        }
        return new Input();
    }

    @Override
    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public OutputSocket<?> getOutputSocket(final FsEntryName name, final BitField<FsOutputOption> options, final @CheckForNull Entry template) {
        class Output
        extends DelegatingOutputSocket<Entry> {
            Output() {
            }

            @Override
            protected OutputSocket<?> getDelegate() {
                assert (FsCacheController.this.isWriteLockedByCurrentThread());
                EntryCache cache = (EntryCache)FsCacheController.this.caches.get(name);
                if (null == cache) {
                    if (!options.get(FsOutputOption.CACHE)) {
                        return FsCacheController.this.delegate.getOutputSocket(name, options, template);
                    }
                    cache = new EntryCache(name);
                }
                return cache.getOutputSocket(options, template);
            }
        }
        return new Output();
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        assert (this.isWriteLockedByCurrentThread());
        this.delegate.mknod(name, type, options, template);
        EntryCache cache = this.caches.remove(name);
        if (null != cache) {
            cache.clear();
        }
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        assert (this.isWriteLockedByCurrentThread());
        this.delegate.unlink(name, options);
        EntryCache cache = this.caches.remove(name);
        if (null != cache) {
            cache.clear();
        }
    }

    @Override
    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        this.syncCacheEntries(options);
        this.delegate.sync(options.clear(FsSyncOption.CLEAR_CACHE));
        if (this.caches.isEmpty()) {
            this.setMounted(false);
        }
    }

    private void syncCacheEntries(BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        boolean clear;
        assert (this.isWriteLockedByCurrentThread());
        if (0 >= this.caches.size()) {
            return;
        }
        boolean flush = !options.get(FsSyncOption.ABORT_CHANGES);
        boolean bl = clear = !flush || options.get(FsSyncOption.CLEAR_CACHE);
        assert (flush || clear);
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        Iterator<EntryCache> i = this.caches.values().iterator();
        while (i.hasNext()) {
            EntryCache cache = i.next();
            if (flush) {
                try {
                    cache.flush();
                }
                catch (IOException ex) {
                    throw (FsSyncException)builder.fail(new FsSyncException((FsModel)this.getModel(), ex));
                }
            }
            if (!clear) continue;
            i.remove();
            try {
                cache.clear();
            }
            catch (IOException ex) {
                builder.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
            }
        }
        builder.check();
    }

    static /* synthetic */ Logger access$700() {
        return logger;
    }

    @Immutable
    private final class EntryCache {
        final FsEntryName name;
        final IOCache cache;

        EntryCache(FsEntryName name) {
            this.name = name;
            this.cache = IOCache.Strategy.WRITE_BACK.newCache(FsCacheController.this.pool);
        }

        InputSocket<?> getInputSocket(BitField<FsInputOption> options) {
            return this.cache.configure(new Input(options)).getInputSocket();
        }

        OutputSocket<?> getOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
            return SOCKET_FACTORY.newOutputSocket(this, options, template);
        }

        void flush() throws IOException {
            this.cache.flush();
        }

        void clear() throws IOException {
            this.cache.clear();
        }

        void register() {
            assert (FsCacheController.this.isWriteLockedByCurrentThread());
            FsCacheController.this.caches.put(this.name, this);
        }

        @Immutable
        class Output
        extends ClutchOutputSocket<Entry> {
            final BitField<FsOutputOption> options;
            @CheckForNull
            final Entry template;

            Output(@CheckForNull BitField<FsOutputOption> options, Entry template) {
                this.options = options.clear(FsOutputOption.CACHE);
                this.template = template;
            }

            @Override
            protected OutputSocket<? extends Entry> getLazyDelegate() {
                return EntryCache.this.cache.configure(FsCacheController.this.delegate.getOutputSocket(EntryCache.this.name, this.options.clear(FsOutputOption.EXCLUSIVE), this.template)).getOutputSocket();
            }

            @Override
            public Entry getLocalTarget() throws IOException {
                return (Entry)this.getBoundSocket().getLocalTarget();
            }

            @Override
            public final OutputStream newOutputStream() throws IOException {
                this.preOutput();
                return new Stream();
            }

            void preOutput() throws IOException {
                this.mknod(this.options, this.template);
            }

            void postOutput() throws IOException {
                this.mknod(this.options.clear(FsOutputOption.EXCLUSIVE), null != this.template ? this.template : EntryCache.this.cache.getEntry());
                EntryCache.this.register();
            }

            /*
             * Unable to fully structure code
             */
            void mknod(BitField<FsOutputOption> mknodOpts, @CheckForNull Entry template) throws IOException {
                while (true) {
                    try {
                        FsCacheController.this.delegate.mknod(EntryCache.this.name, Entry.Type.FILE, mknodOpts, template);
                    }
                    catch (FsNeedsSyncException mknodEx) {
                        if (mknodOpts.get(FsOutputOption.EXCLUSIVE)) {
                            throw mknodEx;
                        }
                        syncOpts = FsSyncController.modify(FsSyncOptions.SYNC);
                        if (FsSyncOptions.SYNC == syncOpts) {
                            throw mknodEx;
                        }
                        try {
                            FsCacheController.this.delegate.sync(syncOpts);
                            continue;
                        }
                        catch (FsSyncException syncEx) {
                            if (JSE7.AVAILABLE) {
                                syncEx.addSuppressed(mknodEx);
                            }
                            if (!(syncEx.getCause() instanceof FsResourceOpenException)) {
                                throw syncEx;
                            }
                            oldMknodOpts = mknodOpts;
                            if ((mknodOpts = oldMknodOpts.set(FsOutputOption.GROW)) == oldMknodOpts) ** break;
                            continue;
                            FsCacheController.access$700().log(Level.FINE, "ignoring", syncEx);
                        }
                    }
                    break;
                }
            }

            final class Stream
            extends DecoratingOutputStream {
                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                Stream() throws IOException {
                    super(Output.this.getBoundSocket().newOutputStream());
                    EntryCache.this.register();
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    Output.this.postOutput();
                }
            }
        }

        @Immutable
        final class Nio2Output
        extends Output {
            Nio2Output(@CheckForNull BitField<FsOutputOption> options, Entry template) {
                super(options, template);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                this.preOutput();
                return new Channel();
            }

            final class Channel
            extends DecoratingSeekableByteChannel {
                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                Channel() throws IOException {
                    super(Nio2Output.this.getBoundSocket().newSeekableByteChannel());
                    EntryCache.this.register();
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    Nio2Output.this.postOutput();
                }
            }
        }

        @Immutable
        final class Input
        extends ClutchInputSocket<Entry> {
            final BitField<FsInputOption> options;

            Input(BitField<FsInputOption> options) {
                this.options = options.clear(FsInputOption.CACHE);
            }

            @Override
            protected InputSocket<? extends Entry> getLazyDelegate() {
                return FsCacheController.this.delegate.getInputSocket(EntryCache.this.name, this.options);
            }

            @Override
            public Entry getLocalTarget() throws IOException {
                return (Entry)this.getBoundSocket().getLocalTarget();
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream newInputStream() throws IOException {
                return new Stream();
            }

            final class Stream
            extends DecoratingInputStream {
                @CreatesObligation
                @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
                Stream() throws IOException {
                    super(Input.this.getBoundSocket().newInputStream());
                    assert (FsCacheController.this.isMounted());
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    EntryCache.this.register();
                }
            }
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            OutputSocket<?> newOutputSocket(EntryCache cache, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                EntryCache entryCache = cache;
                entryCache.getClass();
                return entryCache.new EntryCache.Nio2Output(options, template);
            }
        }
        ,
        OIO{

            @Override
            OutputSocket<?> newOutputSocket(EntryCache cache, BitField<FsOutputOption> options, @CheckForNull Entry template) {
                EntryCache entryCache = cache;
                entryCache.getClass();
                return entryCache.new EntryCache.Output(options, template);
            }
        };


        abstract OutputSocket<?> newOutputSocket(EntryCache var1, BitField<FsOutputOption> var2, @CheckForNull Entry var3);
    }
}

