/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.CharConversionException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.io.Paths;

@Immutable
public abstract class FsCharsetArchiveDriver<E extends FsArchiveEntry>
extends FsArchiveDriver<E> {
    private final Charset charset;
    private final ThreadLocal<CharsetEncoder> encoder = new ThreadLocal();

    protected FsCharsetArchiveDriver(Charset charset) {
        this.charset = charset;
        if (null == this.charset) {
            throw new NullPointerException();
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public static String toZipOrTarEntryName(String name, Entry.Type type) {
        return Entry.Type.DIRECTORY == type ? (name.endsWith("/") ? name : name + '/') : Paths.cutTrailingSeparators(name, '/');
    }

    @Override
    protected final void assertEncodable(String name) throws CharConversionException {
        CharsetEncoder enc = this.encoder.get();
        if (null == enc) {
            enc = this.getCharset().newEncoder();
            this.encoder.set(enc);
        }
        if (!enc.canEncode(name)) {
            throw new CharConversionException(name + " (entry name not encodable with " + this.getCharset() + ")");
        }
    }

    @Override
    public String toString() {
        return String.format("%s[charset=%s, federated=%b, priority=%d]", this.getClass().getName(), this.getCharset(), this.isFederated(), this.getPriority());
    }
}

