/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.util.Formatter;
import java.util.Set;
import javax.annotation.Nullable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.util.BitField;

public abstract class FsEntry
implements Entry {
    @Override
    public abstract String getName();

    public abstract Set<Entry.Type> getTypes();

    public boolean isType(Entry.Type type) {
        return this.getTypes().contains((Object)type);
    }

    @Nullable
    public abstract Set<String> getMembers();

    public final boolean equals(Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        Set<Entry.Type> typesSet = this.getTypes();
        BitField<Entry.Type> typesBitField = typesSet.isEmpty() ? BitField.noneOf(Entry.Type.class) : BitField.copyOf(typesSet);
        StringBuilder s = new StringBuilder(256);
        Formatter f = new Formatter(s).format("%s[name=%s, types=%s", this.getClass().getName(), this.getName(), typesBitField);
        for (Enum type : ALL_SIZE_SET) {
            long size = this.getSize((Entry.Size)type);
            if (-1L == size) continue;
            f.format(", size(%s)=%d", type, size);
        }
        for (Enum type : ALL_ACCESS_SET) {
            long time = this.getTime((Entry.Access)type);
            if (-1L == time) continue;
            f.format(", time(%s)=%tc", type, time);
        }
        return f.format(", members=%s]", this.getMembers()).toString();
    }
}

