/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.fs.FsMountPoint;

@ThreadSafe
public abstract class FsModel {
    private final FsMountPoint mountPoint;
    @CheckForNull
    private final FsModel parent;

    protected FsModel(FsMountPoint mountPoint, @CheckForNull FsModel parent) {
        if (!FsModel.equals(mountPoint.getParent(), null == parent ? null : parent.getMountPoint())) {
            throw new IllegalArgumentException("Parent/Member mismatch!");
        }
        this.mountPoint = mountPoint;
        this.parent = parent;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || null != o1 && o1.equals(o2);
    }

    public final FsMountPoint getMountPoint() {
        return this.mountPoint;
    }

    @CheckForNull
    public final FsModel getParent() {
        return this.parent;
    }

    public abstract boolean isMounted();

    public abstract void setMounted(boolean var1);

    public final boolean equals(Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.format("%s[mountPoint=%s, parent=%s, mounted=%b]", this.getClass().getName(), this.getMountPoint(), this.getParent(), this.isMounted());
    }
}

