/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipOutputShop;
import zz.de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.socket.MultiplexedOutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;

@NotThreadSafe
public class OdfOutputShop
extends MultiplexedOutputShop<ZipDriverEntry> {
    private static final String MIMETYPE = "mimetype";
    private boolean mimetype;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public OdfOutputShop(@WillCloseWhenClosed ZipOutputShop output, IOPool<?> pool) {
        super(output, pool);
    }

    @Override
    public OutputSocket<ZipDriverEntry> getOutputSocket(final ZipDriverEntry entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends DecoratingOutputSocket<ZipDriverEntry> {
            Output() {
                super(OdfOutputShop.super.getOutputSocket(zipDriverEntry));
            }

            @Override
            public ZipDriverEntry getLocalTarget() throws IOException {
                return entry;
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                if (OdfOutputShop.MIMETYPE.equals(entry.getName())) {
                    OdfOutputShop.this.mimetype = true;
                    if (-1 == entry.getMethod()) {
                        entry.setMethod(0);
                    }
                }
                return super.newOutputStream();
            }
        }
        return new Output();
    }

    @Override
    public boolean isBusy() {
        return !this.mimetype || super.isBusy();
    }

    @Override
    public void close() throws IOException {
        this.mimetype = true;
        super.close();
    }
}

