/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import zz.de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.socket.InputShop;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.util.JSE7;
import zz.de.schlichtherle.truezip.zip.RawZipFile;
import zz.de.schlichtherle.truezip.zip.ZipCryptoParameters;

@NotThreadSafe
public class ZipInputShop
extends RawZipFile<ZipDriverEntry>
implements InputShop<ZipDriverEntry> {
    private final ZipDriver driver;
    private final FsModel model;
    private boolean appendee;
    private ZipCryptoParameters param;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipInputShop(ZipDriver driver, FsModel model, @WillCloseWhenClosed ReadOnlyFile rof) throws IOException {
        super(rof, driver);
        this.driver = driver;
        this.model = model;
        if (null == this.model) {
            NullPointerException ex;
            block3: {
                ex = new NullPointerException();
                try {
                    super.close();
                }
                catch (Throwable ex2) {
                    if (!JSE7.AVAILABLE) break block3;
                    ex.addSuppressed(ex2);
                }
            }
            throw ex;
        }
    }

    public FsModel getModel() {
        return this.model;
    }

    @Override
    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters param = this.param;
        if (null == param) {
            this.param = param = this.driver.zipCryptoParameters(this);
        }
        return param;
    }

    protected boolean isAppendee() {
        return this.appendee;
    }

    final void setAppendee(boolean appendee) {
        this.appendee = appendee;
    }

    @Override
    public int getSize() {
        return super.size();
    }

    @Override
    public InputSocket<ZipDriverEntry> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        class Input
        extends InputSocket<ZipDriverEntry> {
            Input() {
            }

            @Override
            public ZipDriverEntry getLocalTarget() throws IOException {
                ZipDriverEntry entry = (ZipDriverEntry)ZipInputShop.this.getEntry(name);
                if (null == entry) {
                    throw new FileNotFoundException(name + " (entry not found)");
                }
                if (entry.isDirectory()) {
                    throw new FileNotFoundException(name + " (cannot read directory entries)");
                }
                return entry;
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream newInputStream() throws IOException {
                ZipDriverEntry local = this.getLocalTarget();
                Entry peer = this.getPeerTarget();
                ZipDriverEntry zpeer = peer instanceof ZipDriverEntry ? (ZipDriverEntry)peer : null;
                ZipDriver driver = ZipInputShop.this.driver;
                return ZipInputShop.this.getInputStream(local.getName(), driver.check(ZipInputShop.this, local), null == zpeer || 0L == local.getSize() || driver.process(ZipInputShop.this, local, zpeer));
            }
        }
        return new Input();
    }
}

