/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.sl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.fs.FsDefaultManager;
import zz.de.schlichtherle.truezip.fs.FsManager;
import zz.de.schlichtherle.truezip.fs.FsManagerProvider;
import zz.de.schlichtherle.truezip.fs.spi.FsManagerDecorator;
import zz.de.schlichtherle.truezip.fs.spi.FsManagerService;
import zz.de.schlichtherle.truezip.util.ServiceLocator;

@Immutable
public final class FsManagerLocator
implements FsManagerProvider {
    public static final FsManagerLocator SINGLETON = new FsManagerLocator();

    private FsManagerLocator() {
    }

    @Override
    public FsManager get() {
        return Boot.manager;
    }

    private static final class DefaultManagerService
    extends FsManagerService {
        private DefaultManagerService() {
        }

        @Override
        public FsManager get() {
            return new FsDefaultManager();
        }
    }

    private static final class Boot {
        static final FsManager manager;

        private Boot() {
        }

        private static FsManager create(ServiceLocator locator, Logger logger) {
            FsManagerService service = locator.getService(FsManagerService.class, null);
            if (null == service) {
                Iterator<FsManagerService> i = locator.getServices(FsManagerService.class);
                while (i.hasNext()) {
                    int np;
                    FsManagerService newService = i.next();
                    logger.log(Level.CONFIG, "located", newService);
                    if (null == service) {
                        service = newService;
                        continue;
                    }
                    int op = service.getPriority();
                    if (op < (np = newService.getPriority())) {
                        service = newService;
                        continue;
                    }
                    if (op != np) continue;
                    logger.log(Level.WARNING, "collision", new Object[]{op, service, newService});
                }
            }
            if (null == service) {
                service = new DefaultManagerService();
            }
            logger.log(Level.CONFIG, "using", service);
            FsManager manager = service.get();
            logger.log(Level.CONFIG, "result", manager);
            return manager;
        }

        private static FsManager decorate(FsManager manager, ServiceLocator locator, Logger logger) {
            ArrayList<FsManagerDecorator> list = new ArrayList<FsManagerDecorator>();
            Iterator<FsManagerDecorator> i = locator.getServices(FsManagerDecorator.class);
            while (i.hasNext()) {
                list.add(i.next());
            }
            FsManagerDecorator[] array = list.toArray(new FsManagerDecorator[list.size()]);
            Arrays.sort(array, new Comparator<FsManagerDecorator>(){

                @Override
                public int compare(FsManagerDecorator o1, FsManagerDecorator o2) {
                    return o1.getPriority() - o2.getPriority();
                }
            });
            for (FsManagerDecorator decorator : array) {
                logger.log(Level.CONFIG, "decorating", decorator);
                manager = decorator.decorate(manager);
                logger.log(Level.CONFIG, "result", manager);
            }
            return manager;
        }

        static {
            Class<FsManagerLocator> clazz = FsManagerLocator.class;
            Logger logger = Logger.getLogger(clazz.getName(), clazz.getName());
            ServiceLocator locator = new ServiceLocator(clazz.getClassLoader());
            manager = Boot.decorate(Boot.create(locator, logger), locator, logger);
        }
    }
}

