/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.key;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.key.KeyManager;
import zz.de.schlichtherle.truezip.key.SafeKey;
import zz.de.schlichtherle.truezip.key.SafeKeyProvider;

@ThreadSafe
public abstract class SafeKeyManager<K extends SafeKey<K>, P extends SafeKeyProvider<K>>
implements KeyManager<K> {
    private final Map<URI, P> providers = new HashMap<URI, P>();

    protected SafeKeyManager() {
    }

    protected abstract P newKeyProvider();

    public synchronized P getKeyProvider(URI resource) {
        if (null == resource) {
            throw new NullPointerException();
        }
        SafeKeyProvider<Object> provider = (SafeKeyProvider)this.providers.get(resource);
        if (null == provider) {
            provider = this.newKeyProvider();
            this.providers.put(resource, provider);
        }
        return (P)provider;
    }

    @Nullable
    public synchronized P getMappedKeyProvider(URI resource) {
        if (null == resource) {
            throw new NullPointerException();
        }
        return (P)((SafeKeyProvider)this.providers.get(resource));
    }

    public synchronized P moveKeyProvider(URI oldResource, URI newResource) {
        if (null == newResource) {
            throw new NullPointerException();
        }
        if (oldResource.equals(newResource)) {
            throw new IllegalArgumentException();
        }
        SafeKeyProvider provider = (SafeKeyProvider)this.providers.remove(oldResource);
        if (null != provider) {
            return (P)this.providers.put(newResource, provider);
        }
        return (P)((SafeKeyProvider)this.providers.remove(newResource));
    }

    public synchronized P removeKeyProvider(URI resource) {
        if (null == resource) {
            throw new NullPointerException();
        }
        SafeKeyProvider provider = (SafeKeyProvider)this.providers.remove(resource);
        if (null != provider) {
            provider.setKey(null);
        }
        return (P)provider;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public String toString() {
        return String.format("%s[priority=%d]", this.getClass().getName(), this.getPriority());
    }
}

