/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.key.sl;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.fs.spi.FsDriverService;
import zz.de.schlichtherle.truezip.key.AbstractKeyManagerProvider;
import zz.de.schlichtherle.truezip.key.KeyManager;
import zz.de.schlichtherle.truezip.key.spi.KeyManagerService;
import zz.de.schlichtherle.truezip.util.HashMaps;
import zz.de.schlichtherle.truezip.util.ServiceLocator;

@Immutable
public final class KeyManagerLocator
extends AbstractKeyManagerProvider {
    public static final KeyManagerLocator SINGLETON = new KeyManagerLocator();

    private KeyManagerLocator() {
    }

    @Override
    public Map<Class<?>, KeyManager<?>> get() {
        return Boot.MANAGERS;
    }

    private static final class ClassComparator
    implements Comparator<Class<?>> {
        static final ClassComparator INSTANCE = new ClassComparator();

        private ClassComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static final class Boot {
        static final Map<Class<?>, KeyManager<?>> MANAGERS;

        private Boot() {
        }

        static {
            Class type;
            Logger logger = Logger.getLogger(KeyManagerLocator.class.getName(), KeyManagerLocator.class.getName());
            Iterator<KeyManagerService> i = new ServiceLocator(KeyManagerLocator.class.getClassLoader()).getServices(KeyManagerService.class);
            TreeMap<Class, KeyManager> sorted = new TreeMap<Class, KeyManager>(ClassComparator.INSTANCE);
            if (!i.hasNext()) {
                logger.log(Level.WARNING, "null", FsDriverService.class);
            }
            while (i.hasNext()) {
                KeyManagerService service = i.next();
                logger.log(Level.CONFIG, "located", service);
                for (Map.Entry<Object, Object> entry : service.get().entrySet()) {
                    KeyManager oldManager;
                    type = (Class)entry.getKey();
                    KeyManager newManager = (KeyManager)entry.getValue();
                    if (null == type || null == newManager || null == (oldManager = sorted.put(type, newManager)) || oldManager.getPriority() <= newManager.getPriority()) continue;
                    sorted.put(type, oldManager);
                }
            }
            LinkedHashMap<Class, KeyManager> fast = new LinkedHashMap<Class, KeyManager>(HashMaps.initialCapacity(sorted.size()));
            for (Map.Entry<Object, Object> entry : sorted.entrySet()) {
                type = (Class)entry.getKey();
                KeyManager manager = (KeyManager)entry.getValue();
                logger.log(Level.CONFIG, "mapping", new Object[]{type, manager});
                fast.put(type, manager);
            }
            MANAGERS = Collections.unmodifiableMap(fast);
        }
    }
}

