/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.socket;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.io.LockOutputStream;
import zz.de.schlichtherle.truezip.socket.DecoratingOutputShop;
import zz.de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import zz.de.schlichtherle.truezip.socket.OutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;

@ThreadSafe
public class LockOutputShop<E extends Entry>
extends DecoratingOutputShop<E, OutputShop<E>> {
    private final Lock lock;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LockOutputShop(@WillCloseWhenClosed OutputShop<E> output) {
        this(output, new ReentrantLock());
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public LockOutputShop(@WillCloseWhenClosed OutputShop<E> output, Lock lock) {
        super(output);
        this.lock = lock;
        if (null == this.lock) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DischargesObligation
    @GuardedBy(value="lock")
    public void close() throws IOException {
        this.lock.lock();
        try {
            ((OutputShop)this.delegate).close();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    @GuardedBy(value="lock")
    public E getEntry(String name) {
        this.lock.lock();
        try {
            Object e = ((OutputShop)this.delegate).getEntry(name);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public int getSize() {
        this.lock.lock();
        try {
            int n = ((OutputShop)this.delegate).getSize();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("The returned iterator would not be thread-safe!");
    }

    @Override
    public OutputSocket<? extends E> getOutputSocket(E entry) {
        class Output
        extends DecoratingOutputSocket<E> {
            final /* synthetic */ Entry val$entry;

            Output() {
                this.val$entry = entry;
                super(LockOutputShop.super.getOutputSocket(entry));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @GuardedBy(value="lock")
            public E getLocalTarget() throws IOException {
                LockOutputShop.this.lock.lock();
                try {
                    Entry entry = this.val$entry;
                    return entry;
                }
                finally {
                    LockOutputShop.this.lock.unlock();
                }
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                throw new UnsupportedOperationException("TODO: Implement this!");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @GuardedBy(value="lock")
            public OutputStream newOutputStream() throws IOException {
                OutputStream out;
                LockOutputShop.this.lock.lock();
                try {
                    out = this.getBoundSocket().newOutputStream();
                }
                finally {
                    LockOutputShop.this.lock.unlock();
                }
                return new LockOutputStream(out, LockOutputShop.this.lock);
            }
        }
        return new Output();
    }
}

