/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JointIterator<E>
implements Iterator<E> {
    private Iterator<? extends E> i1;
    private Iterator<? extends E> i2;

    public JointIterator(Iterator<? extends E> i1, Iterator<? extends E> i2) {
        if (i1 == null || i2 == null) {
            throw new NullPointerException();
        }
        this.i1 = i1;
        this.i2 = i2;
    }

    public JointIterator(Iterable<? extends E> i1, Iterable<? extends E> i2) {
        this.i1 = i1.iterator();
        this.i2 = i2.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.i1.hasNext() || this.i1 != this.i2 && (this.i1 = this.i2).hasNext();
    }

    @Override
    public E next() {
        try {
            return this.i1.next();
        }
        catch (NoSuchElementException ex) {
            if (this.i1 == this.i2) {
                throw ex;
            }
            this.i1 = this.i2;
            return this.i1.next();
        }
    }

    @Override
    public void remove() {
        this.i1.remove();
    }
}

