/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import zz.de.schlichtherle.truezip.util.UriEncoder;

@NotThreadSafe
public final class UriBuilder {
    private final UriEncoder encoder;
    @CheckForNull
    private StringBuilder builder;
    @CheckForNull
    private String scheme;
    @CheckForNull
    private String authority;
    @CheckForNull
    private String path;
    @CheckForNull
    private String query;
    @CheckForNull
    private String fragment;

    public UriBuilder() {
        this(false);
    }

    public UriBuilder(boolean raw) {
        this.encoder = new UriEncoder(null, raw);
    }

    public UriBuilder(URI uri) {
        this(uri, false);
    }

    public UriBuilder(URI uri, boolean raw) {
        this.encoder = new UriEncoder(null, raw);
        this.setUri(uri);
    }

    public UriBuilder clear() {
        this.scheme = null;
        this.authority = null;
        this.path = null;
        this.query = null;
        this.fragment = null;
        return this;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getString() throws URISyntaxException {
        boolean hasAuth;
        boolean absUri;
        StringBuilder r = this.resetBuilder();
        int errIdx = -1;
        String errMsg = null;
        String s = this.scheme;
        String a = this.authority;
        String p = this.path;
        String q = this.query;
        String f = this.fragment;
        boolean bl = absUri = null != s;
        if (absUri) {
            r.append(s).append(':');
        }
        int ssp = r.length();
        boolean bl2 = hasAuth = null != a;
        if (hasAuth) {
            this.encoder.encode(a, UriEncoder.Encoding.AUTHORITY, r.append("//"));
        }
        boolean absPath = false;
        if (null != p && !p.isEmpty()) {
            if (p.startsWith("/")) {
                absPath = true;
                this.encoder.encode(p, UriEncoder.Encoding.ABSOLUTE_PATH, r);
            } else if (hasAuth) {
                absPath = true;
                errIdx = r.length();
                errMsg = "Relative path with " + (a.isEmpty() ? "" : "non-") + "empty authority";
                this.encoder.encode(p, UriEncoder.Encoding.ABSOLUTE_PATH, r);
            } else if (absUri) {
                this.encoder.encode(p, UriEncoder.Encoding.QUERY, r);
            } else {
                this.encoder.encode(p, UriEncoder.Encoding.PATH, r);
            }
        }
        if (null != q) {
            r.append('?');
            if (absUri && !absPath) {
                errIdx = r.length();
                errMsg = "Query in opaque URI";
            }
            this.encoder.encode(q, UriEncoder.Encoding.QUERY, r);
        }
        assert (absUri == 0 < ssp);
        if (absUri && ssp >= r.length()) {
            errIdx = r.length();
            errMsg = "Empty scheme specific part in absolute URI";
        }
        if (null != f) {
            this.encoder.encode(f, UriEncoder.Encoding.FRAGMENT, r.append('#'));
        }
        if (absUri) {
            UriBuilder.validateScheme((CharBuffer)CharBuffer.wrap(r).limit(s.length()));
        }
        String u = r.toString();
        if (0 <= errIdx) {
            throw new QuotedUriSyntaxException((Object)u, errMsg, errIdx);
        }
        return u;
    }

    private StringBuilder resetBuilder() {
        StringBuilder builder = this.builder;
        if (null == builder) {
            this.builder = builder = new StringBuilder();
        } else {
            builder.setLength(0);
        }
        return builder;
    }

    public static void validateScheme(String scheme) throws URISyntaxException {
        UriBuilder.validateScheme(CharBuffer.wrap(scheme));
    }

    private static void validateScheme(CharBuffer input) throws URISyntaxException {
        if (!input.hasRemaining()) {
            throw UriBuilder.newURISyntaxException(input, "Empty URI scheme");
        }
        char c = input.get();
        if (!(c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c)) {
            throw UriBuilder.newURISyntaxException(input, "Illegal character in URI scheme");
        }
        while (input.hasRemaining()) {
            c = input.get();
            if (c >= 'a' && 'z' >= c || c >= 'A' && 'Z' >= c || c >= '0' && '9' >= c || c == '+' || c == '-' || c == '.') continue;
            throw UriBuilder.newURISyntaxException(input, "Illegal character in URI scheme");
        }
    }

    private static URISyntaxException newURISyntaxException(CharBuffer input, String reason) {
        int p = input.position() - 1;
        return new QuotedUriSyntaxException(input.rewind().limit(input.capacity()), reason, p);
    }

    public void setString(String uri) {
        this.setUri(URI.create(uri));
    }

    public UriBuilder string(String uri) {
        this.setString(uri);
        return this;
    }

    public URI toUri() {
        try {
            return this.getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public URI getUri() throws URISyntaxException {
        String u = this.getString();
        try {
            return new URI(u);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void setUri(URI uri) {
        if (this.encoder.isRaw()) {
            this.setScheme(uri.getScheme());
            this.setAuthority(uri.getRawAuthority());
            this.setPath(uri.isOpaque() ? uri.getRawSchemeSpecificPart() : uri.getRawPath());
            this.setQuery(uri.getRawQuery());
            this.setFragment(uri.getRawFragment());
        } else {
            this.setScheme(uri.getScheme());
            this.setAuthority(uri.getAuthority());
            this.setPath(uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath());
            this.setQuery(uri.getQuery());
            this.setFragment(uri.getFragment());
        }
    }

    public UriBuilder uri(URI uri) {
        this.setUri(uri);
        return this;
    }

    @CheckForNull
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(@CheckForNull String scheme) {
        this.scheme = scheme;
    }

    public UriBuilder scheme(@CheckForNull String scheme) {
        this.setScheme(scheme);
        return this;
    }

    @CheckForNull
    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(@CheckForNull String authority) {
        this.authority = authority;
    }

    public UriBuilder authority(@CheckForNull String authority) {
        this.setAuthority(authority);
        return this;
    }

    @CheckForNull
    public String getPath() {
        return this.path;
    }

    public void setPath(@CheckForNull String path) {
        this.path = path;
    }

    public UriBuilder path(@CheckForNull String path) {
        this.setPath(path);
        return this;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    public void setQuery(@CheckForNull String query) {
        this.query = query;
    }

    public UriBuilder query(@CheckForNull String query) {
        this.setQuery(query);
        return this;
    }

    public void setPathQuery(@CheckForNull String pathQuery) {
        int i;
        if (null != pathQuery && 0 <= (i = pathQuery.indexOf(63))) {
            this.path = pathQuery.substring(0, i);
            this.query = pathQuery.substring(i + 1);
        } else {
            this.path = pathQuery;
            this.query = null;
        }
    }

    public UriBuilder pathQuery(@CheckForNull String pathQuery) {
        this.setPathQuery(pathQuery);
        return this;
    }

    @CheckForNull
    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(@CheckForNull String fragment) {
        this.fragment = fragment;
    }

    public UriBuilder fragment(@CheckForNull String fragment) {
        this.setFragment(fragment);
        return this;
    }
}

