/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.io.DecoratingInputStream;

@NotThreadSafe
final class CountingInputStream
extends DecoratingInputStream {
    private long bytesRead;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    CountingInputStream(@Nullable @WillCloseWhenClosed InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.delegate.read(b, off, len);
        if (read > 0) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        int read = this.delegate.read();
        if (read != -1) {
            ++this.bytesRead;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.delegate.skip(n);
        this.bytesRead += skipped;
        return skipped;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

