/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import zz.de.schlichtherle.truezip.crypto.SICSeekableBlockCipher;
import zz.org.bouncycastle.crypto.BlockCipher;
import zz.org.bouncycastle.crypto.DataLengthException;
import zz.org.bouncycastle.crypto.engines.AESFastEngine;

final class WinZipAesCipher
extends SICSeekableBlockCipher {
    WinZipAesCipher() {
        super((BlockCipher)new AESFastEngine());
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int blockSize;
        this.incCounter();
        this.cipher.processBlock(this.cipherIn, 0, this.cipherOut, 0);
        int i = blockSize = this.blockSize;
        inOff += i;
        outOff += i;
        while (i > 0) {
            out[--outOff] = (byte)(in[--inOff] ^ this.cipherOut[--i]);
        }
        return blockSize;
    }

    private void incCounter() {
        int blockSize = this.blockSize;
        long blockCounter = ++this.blockCounter;
        for (int i = 0; i < blockSize; ++i) {
            this.cipherIn[i] = (byte)(blockCounter += (long)(this.IV[i] & 0xFF));
            blockCounter >>>= 8;
        }
    }
}

