/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import zz.org.eclipse.jgit.diff.ContentSource;
import zz.org.eclipse.jgit.diff.DiffConfig;
import zz.org.eclipse.jgit.diff.DiffEntry;
import zz.org.eclipse.jgit.diff.SimilarityIndex;
import zz.org.eclipse.jgit.diff.SimilarityRenameDetector;
import zz.org.eclipse.jgit.errors.CancelledException;
import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.lib.AbbreviatedObjectId;
import zz.org.eclipse.jgit.lib.FileMode;
import zz.org.eclipse.jgit.lib.NullProgressMonitor;
import zz.org.eclipse.jgit.lib.ObjectReader;
import zz.org.eclipse.jgit.lib.ProgressMonitor;
import zz.org.eclipse.jgit.lib.Repository;

public class RenameDetector {
    private static final int EXACT_RENAME_SCORE = 100;
    private static final Comparator<DiffEntry> DIFF_COMPARATOR = new Comparator<DiffEntry>(){

        @Override
        public int compare(DiffEntry a, DiffEntry b) {
            int cmp = this.nameOf(a).compareTo(this.nameOf(b));
            if (cmp == 0) {
                cmp = this.sortOf(a.getChangeType()) - this.sortOf(b.getChangeType());
            }
            return cmp;
        }

        private String nameOf(DiffEntry ent) {
            if (ent.changeType == DiffEntry.ChangeType.DELETE) {
                return ent.oldPath;
            }
            return ent.newPath;
        }

        private int sortOf(DiffEntry.ChangeType changeType) {
            switch (changeType) {
                case DELETE: {
                    return 1;
                }
                case ADD: {
                    return 2;
                }
            }
            return 10;
        }
    };
    private List<DiffEntry> entries;
    private List<DiffEntry> deleted;
    private List<DiffEntry> added;
    private boolean done;
    private final ObjectReader objectReader;
    private int renameScore = 60;
    private int breakScore = -1;
    private int renameLimit;
    private boolean overRenameLimit;

    public RenameDetector(Repository repo) {
        this(repo.newObjectReader(), repo.getConfig().get(DiffConfig.KEY));
    }

    public RenameDetector(ObjectReader reader, DiffConfig cfg) {
        this.objectReader = reader.newReader();
        this.renameLimit = cfg.getRenameLimit();
        this.reset();
    }

    public int getRenameScore() {
        return this.renameScore;
    }

    public void setRenameScore(int score) {
        if (score < 0 || score > 100) {
            throw new IllegalArgumentException(JGitText.get().similarityScoreMustBeWithinBounds);
        }
        this.renameScore = score;
    }

    public int getBreakScore() {
        return this.breakScore;
    }

    public void setBreakScore(int breakScore) {
        this.breakScore = breakScore;
    }

    public int getRenameLimit() {
        return this.renameLimit;
    }

    public void setRenameLimit(int limit) {
        this.renameLimit = limit;
    }

    public boolean isOverRenameLimit() {
        if (this.done) {
            return this.overRenameLimit;
        }
        int cnt = Math.max(this.added.size(), this.deleted.size());
        return this.getRenameLimit() != 0 && this.getRenameLimit() < cnt;
    }

    public void addAll(Collection<DiffEntry> entriesToAdd) {
        if (this.done) {
            throw new IllegalStateException(JGitText.get().renamesAlreadyFound);
        }
        for (DiffEntry entry : entriesToAdd) {
            switch (entry.getChangeType()) {
                case ADD: {
                    this.added.add(entry);
                    break;
                }
                case DELETE: {
                    this.deleted.add(entry);
                    break;
                }
                case MODIFY: {
                    if (RenameDetector.sameType(entry.getOldMode(), entry.getNewMode())) {
                        this.entries.add(entry);
                        break;
                    }
                    List<DiffEntry> tmp = DiffEntry.breakModify(entry);
                    this.deleted.add(tmp.get(0));
                    this.added.add(tmp.get(1));
                    break;
                }
                default: {
                    this.entries.add(entry);
                }
            }
        }
    }

    public void add(DiffEntry entry) {
        this.addAll(Collections.singletonList(entry));
    }

    public List<DiffEntry> compute() throws IOException {
        return this.compute(NullProgressMonitor.INSTANCE);
    }

    public List<DiffEntry> compute(ProgressMonitor pm) throws IOException, CancelledException {
        if (!this.done) {
            try {
                List<DiffEntry> list = this.compute(this.objectReader, pm);
                return list;
            }
            finally {
                this.objectReader.close();
            }
        }
        return Collections.unmodifiableList(this.entries);
    }

    public List<DiffEntry> compute(ObjectReader reader, ProgressMonitor pm) throws IOException, CancelledException {
        ContentSource cs = ContentSource.create(reader);
        return this.compute(new ContentSource.Pair(cs, cs), pm);
    }

    public List<DiffEntry> compute(ContentSource.Pair reader, ProgressMonitor pm) throws IOException, CancelledException {
        if (!this.done) {
            this.done = true;
            if (pm == null) {
                pm = NullProgressMonitor.INSTANCE;
            }
            if (this.breakScore > 0) {
                this.breakModifies(reader, pm);
            }
            if (!this.added.isEmpty() && !this.deleted.isEmpty()) {
                this.findExactRenames(pm);
            }
            if (!this.added.isEmpty() && !this.deleted.isEmpty()) {
                this.findContentRenames(reader, pm);
            }
            if (this.breakScore > 0 && !this.added.isEmpty() && !this.deleted.isEmpty()) {
                this.rejoinModifies(pm);
            }
            this.entries.addAll(this.added);
            this.added = null;
            this.entries.addAll(this.deleted);
            this.deleted = null;
            Collections.sort(this.entries, DIFF_COMPARATOR);
        }
        return Collections.unmodifiableList(this.entries);
    }

    public void reset() {
        this.entries = new ArrayList<DiffEntry>();
        this.deleted = new ArrayList<DiffEntry>();
        this.added = new ArrayList<DiffEntry>();
        this.done = false;
    }

    private void advanceOrCancel(ProgressMonitor pm) throws CancelledException {
        if (pm.isCancelled()) {
            throw new CancelledException(JGitText.get().renameCancelled);
        }
        pm.update(1);
    }

    private void breakModifies(ContentSource.Pair reader, ProgressMonitor pm) throws IOException, CancelledException {
        ArrayList<DiffEntry> newEntries = new ArrayList<DiffEntry>(this.entries.size());
        pm.beginTask(JGitText.get().renamesBreakingModifies, this.entries.size());
        int i = 0;
        while (i < this.entries.size()) {
            DiffEntry e = this.entries.get(i);
            if (e.getChangeType() == DiffEntry.ChangeType.MODIFY) {
                int score = this.calculateModifyScore(reader, e);
                if (score < this.breakScore) {
                    List<DiffEntry> tmp = DiffEntry.breakModify(e);
                    DiffEntry del = tmp.get(0);
                    del.score = score;
                    this.deleted.add(del);
                    this.added.add(tmp.get(1));
                } else {
                    newEntries.add(e);
                }
            } else {
                newEntries.add(e);
            }
            this.advanceOrCancel(pm);
            ++i;
        }
        this.entries = newEntries;
    }

    private void rejoinModifies(ProgressMonitor pm) throws CancelledException {
        HashMap<String, DiffEntry> nameMap = new HashMap<String, DiffEntry>();
        ArrayList<DiffEntry> newAdded = new ArrayList<DiffEntry>(this.added.size());
        pm.beginTask(JGitText.get().renamesRejoiningModifies, this.added.size() + this.deleted.size());
        for (DiffEntry src : this.deleted) {
            nameMap.put(src.oldPath, src);
            this.advanceOrCancel(pm);
        }
        for (DiffEntry dst : this.added) {
            DiffEntry src = (DiffEntry)nameMap.remove(dst.newPath);
            if (src != null) {
                if (RenameDetector.sameType(src.oldMode, dst.newMode)) {
                    this.entries.add(DiffEntry.pair(DiffEntry.ChangeType.MODIFY, src, dst, src.score));
                } else {
                    nameMap.put(src.oldPath, src);
                    newAdded.add(dst);
                }
            } else {
                newAdded.add(dst);
            }
            this.advanceOrCancel(pm);
        }
        this.added = newAdded;
        this.deleted = new ArrayList(nameMap.values());
    }

    private int calculateModifyScore(ContentSource.Pair reader, DiffEntry d) throws IOException {
        try {
            SimilarityIndex src = new SimilarityIndex();
            src.hash(reader.open(DiffEntry.Side.OLD, d));
            src.sort();
            SimilarityIndex dst = new SimilarityIndex();
            dst.hash(reader.open(DiffEntry.Side.NEW, d));
            dst.sort();
            return src.score(dst, 100);
        }
        catch (SimilarityIndex.TableFullException tableFull) {
            this.overRenameLimit = true;
            return this.breakScore + 1;
        }
    }

    private void findContentRenames(ContentSource.Pair reader, ProgressMonitor pm) throws IOException, CancelledException {
        int cnt = Math.max(this.added.size(), this.deleted.size());
        if (this.getRenameLimit() == 0 || cnt <= this.getRenameLimit()) {
            SimilarityRenameDetector d = new SimilarityRenameDetector(reader, this.deleted, this.added);
            d.setRenameScore(this.getRenameScore());
            d.compute(pm);
            this.overRenameLimit |= d.isTableOverflow();
            this.deleted = d.getLeftOverSources();
            this.added = d.getLeftOverDestinations();
            this.entries.addAll(d.getMatches());
        } else {
            this.overRenameLimit = true;
        }
    }

    private void findExactRenames(ProgressMonitor pm) throws CancelledException {
        DiffEntry best;
        pm.beginTask(JGitText.get().renamesFindingExact, this.added.size() + this.added.size() + this.deleted.size() + this.added.size() * this.deleted.size());
        HashMap<AbbreviatedObjectId, Object> deletedMap = this.populateMap(this.deleted, pm);
        HashMap<AbbreviatedObjectId, Object> addedMap = this.populateMap(this.added, pm);
        ArrayList<DiffEntry> uniqueAdds = new ArrayList<DiffEntry>(this.added.size());
        ArrayList<List> nonUniqueAdds = new ArrayList<List>();
        for (Object o : addedMap.values()) {
            if (o instanceof DiffEntry) {
                uniqueAdds.add((DiffEntry)o);
                continue;
            }
            nonUniqueAdds.add((List)o);
        }
        ArrayList<DiffEntry> left = new ArrayList<DiffEntry>(this.added.size());
        for (DiffEntry a : uniqueAdds) {
            Object del = deletedMap.get(a.newId);
            if (del instanceof DiffEntry) {
                DiffEntry e = (DiffEntry)del;
                if (RenameDetector.sameType(e.oldMode, a.newMode)) {
                    e.changeType = DiffEntry.ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename(e, a));
                } else {
                    left.add(a);
                }
            } else if (del != null) {
                List list = (List)del;
                best = RenameDetector.bestPathMatch(a, list);
                if (best != null) {
                    best.changeType = DiffEntry.ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename(best, a));
                } else {
                    left.add(a);
                }
            } else {
                left.add(a);
            }
            this.advanceOrCancel(pm);
        }
        for (List adds : nonUniqueAdds) {
            Object o = deletedMap.get(((DiffEntry)adds.get((int)0)).newId);
            if (o instanceof DiffEntry) {
                DiffEntry d = (DiffEntry)o;
                best = RenameDetector.bestPathMatch(d, adds);
                if (best != null) {
                    d.changeType = DiffEntry.ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename(d, best));
                    for (DiffEntry a : adds) {
                        if (a == best) continue;
                        if (RenameDetector.sameType(d.oldMode, a.newMode)) {
                            this.entries.add(RenameDetector.exactCopy(d, a));
                            continue;
                        }
                        left.add(a);
                    }
                } else {
                    left.addAll(adds);
                }
            } else if (o != null) {
                List dels = (List)o;
                long[] matrix = new long[dels.size() * adds.size()];
                int mNext = 0;
                int delIdx = 0;
                while (delIdx < dels.size()) {
                    String deletedName = ((DiffEntry)dels.get((int)delIdx)).oldPath;
                    int addIdx = 0;
                    while (addIdx < adds.size()) {
                        String addedName = ((DiffEntry)adds.get((int)addIdx)).newPath;
                        int score = SimilarityRenameDetector.nameScore(addedName, deletedName);
                        matrix[mNext] = SimilarityRenameDetector.encode(score, delIdx, addIdx);
                        ++mNext;
                        if (pm.isCancelled()) {
                            throw new CancelledException(JGitText.get().renameCancelled);
                        }
                        ++addIdx;
                    }
                    ++delIdx;
                }
                Arrays.sort(matrix);
                --mNext;
                while (mNext >= 0) {
                    long ent = matrix[mNext];
                    int delIdx2 = SimilarityRenameDetector.srcFile(ent);
                    int addIdx = SimilarityRenameDetector.dstFile(ent);
                    DiffEntry d = (DiffEntry)dels.get(delIdx2);
                    DiffEntry a = (DiffEntry)adds.get(addIdx);
                    if (a == null) {
                        this.advanceOrCancel(pm);
                    } else {
                        DiffEntry.ChangeType type;
                        if (d.changeType == DiffEntry.ChangeType.DELETE) {
                            d.changeType = DiffEntry.ChangeType.RENAME;
                            type = DiffEntry.ChangeType.RENAME;
                        } else {
                            type = DiffEntry.ChangeType.COPY;
                        }
                        this.entries.add(DiffEntry.pair(type, d, a, 100));
                        adds.set(addIdx, null);
                        this.advanceOrCancel(pm);
                    }
                    --mNext;
                }
            } else {
                left.addAll(adds);
            }
            this.advanceOrCancel(pm);
        }
        this.added = left;
        this.deleted = new ArrayList<DiffEntry>(deletedMap.size());
        for (Object o : deletedMap.values()) {
            if (o instanceof DiffEntry) {
                DiffEntry e = (DiffEntry)o;
                if (e.changeType != DiffEntry.ChangeType.DELETE) continue;
                this.deleted.add(e);
                continue;
            }
            List list = (List)o;
            for (DiffEntry e : list) {
                if (e.changeType != DiffEntry.ChangeType.DELETE) continue;
                this.deleted.add(e);
            }
        }
        pm.endTask();
    }

    private static DiffEntry bestPathMatch(DiffEntry src, List<DiffEntry> list) {
        DiffEntry best = null;
        int score = -1;
        for (DiffEntry d : list) {
            int tmp;
            if (!RenameDetector.sameType(RenameDetector.mode(d), RenameDetector.mode(src)) || (tmp = SimilarityRenameDetector.nameScore(RenameDetector.path(d), RenameDetector.path(src))) <= score) continue;
            best = d;
            score = tmp;
        }
        return best;
    }

    private HashMap<AbbreviatedObjectId, Object> populateMap(List<DiffEntry> diffEntries, ProgressMonitor pm) throws CancelledException {
        HashMap<AbbreviatedObjectId, Object> map = new HashMap<AbbreviatedObjectId, Object>();
        for (DiffEntry de : diffEntries) {
            Object old = map.put(RenameDetector.id(de), de);
            if (old instanceof DiffEntry) {
                ArrayList<DiffEntry> list = new ArrayList<DiffEntry>(2);
                list.add((DiffEntry)old);
                list.add(de);
                map.put(RenameDetector.id(de), list);
            } else if (old != null) {
                ((List)old).add(de);
                map.put(RenameDetector.id(de), old);
            }
            this.advanceOrCancel(pm);
        }
        return map;
    }

    private static String path(DiffEntry de) {
        return de.changeType == DiffEntry.ChangeType.DELETE ? de.oldPath : de.newPath;
    }

    private static FileMode mode(DiffEntry de) {
        return de.changeType == DiffEntry.ChangeType.DELETE ? de.oldMode : de.newMode;
    }

    private static AbbreviatedObjectId id(DiffEntry de) {
        return de.changeType == DiffEntry.ChangeType.DELETE ? de.oldId : de.newId;
    }

    static boolean sameType(FileMode a, FileMode b) {
        int bType;
        int aType = a.getBits() & 0xF000;
        return aType == (bType = b.getBits() & 0xF000);
    }

    private static DiffEntry exactRename(DiffEntry src, DiffEntry dst) {
        return DiffEntry.pair(DiffEntry.ChangeType.RENAME, src, dst, 100);
    }

    private static DiffEntry exactCopy(DiffEntry src, DiffEntry dst) {
        return DiffEntry.pair(DiffEntry.ChangeType.COPY, src, dst, 100);
    }
}

