/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zz.org.eclipse.jgit.annotations.Nullable;
import zz.org.eclipse.jgit.errors.NotSupportedException;
import zz.org.eclipse.jgit.errors.TransportException;
import zz.org.eclipse.jgit.internal.ketch.KetchLeader;
import zz.org.eclipse.jgit.internal.ketch.KetchReplica;
import zz.org.eclipse.jgit.internal.ketch.ReplicaConfig;
import zz.org.eclipse.jgit.internal.ketch.ReplicaFetchRequest;
import zz.org.eclipse.jgit.internal.ketch.ReplicaPushRequest;
import zz.org.eclipse.jgit.lib.AnyObjectId;
import zz.org.eclipse.jgit.lib.NullProgressMonitor;
import zz.org.eclipse.jgit.lib.ObjectId;
import zz.org.eclipse.jgit.lib.ObjectIdRef;
import zz.org.eclipse.jgit.lib.Ref;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.transport.FetchConnection;
import zz.org.eclipse.jgit.transport.PushConnection;
import zz.org.eclipse.jgit.transport.ReceiveCommand;
import zz.org.eclipse.jgit.transport.RemoteConfig;
import zz.org.eclipse.jgit.transport.RemoteRefUpdate;
import zz.org.eclipse.jgit.transport.Transport;
import zz.org.eclipse.jgit.transport.URIish;

public class RemoteGitReplica
extends KetchReplica {
    private final URIish uri;
    private final RemoteConfig remoteConfig;

    public RemoteGitReplica(KetchLeader leader, String name, URIish uri, ReplicaConfig cfg, @Nullable RemoteConfig rc) {
        super(leader, name, cfg);
        this.uri = uri;
        this.remoteConfig = rc;
    }

    public URIish getURI() {
        return this.uri;
    }

    @Nullable
    protected RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    @Override
    protected String describeForLog() {
        return String.format("%s @ %s", this.getName(), this.getURI());
    }

    @Override
    protected void startPush(ReplicaPushRequest req) {
        this.getSystem().getExecutor().execute(() -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Repository git = this.getLeader().openRepository();){
                    try {
                        this.push(git, req);
                        req.done(git);
                    }
                    catch (Throwable err) {
                        req.setException(git, err);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException err) {
                req.setException(null, err);
            }
        });
    }

    private void push(Repository repo, ReplicaPushRequest req) throws NotSupportedException, TransportException, IOException {
        Map<String, Ref> adv;
        List<RemoteCommand> cmds = RemoteGitReplica.asUpdateList(req.getCommands());
        Throwable throwable = null;
        Iterator<RemoteCommand> iterator = null;
        try (Transport transport = Transport.open(repo, this.uri);){
            RemoteConfig rc = this.getRemoteConfig();
            if (rc != null) {
                transport.applyConfig(rc);
            }
            transport.setPushAtomic(true);
            adv = this.push(repo, transport, cmds);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (RemoteCommand c : cmds) {
            c.copyStatusToResult();
        }
        req.setRefs(adv);
    }

    private Map<String, Ref> push(Repository git, Transport transport, List<RemoteCommand> cmds) throws IOException {
        Map<String, RemoteRefUpdate> updates = RemoteGitReplica.asUpdateMap(cmds);
        Throwable throwable = null;
        Object var6_7 = null;
        try (PushConnection connection = transport.openPush();){
            Map<String, Ref> adv = connection.getRefsMap();
            RemoteRefUpdate accepted = updates.get(this.getSystem().getTxnAccepted());
            if (accepted != null && !RemoteGitReplica.isExpectedValue(adv, accepted)) {
                RemoteGitReplica.abort(cmds);
                return adv;
            }
            RemoteRefUpdate committed = updates.get(this.getSystem().getTxnCommitted());
            if (committed != null && !RemoteGitReplica.isExpectedValue(adv, committed)) {
                RemoteGitReplica.abort(cmds);
                return adv;
            }
            if (committed != null && this.getCommitMethod() == KetchReplica.CommitMethod.ALL_REFS) {
                this.prepareCommit(git, cmds, updates, adv, committed.getNewObjectId());
            }
            connection.push(NullProgressMonitor.INSTANCE, updates);
            return adv;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean isExpectedValue(Map<String, Ref> adv, RemoteRefUpdate u) {
        Ref r = adv.get(u.getRemoteName());
        if (!AnyObjectId.isEqual(RemoteGitReplica.getId(r), u.getExpectedOldObjectId())) {
            ((RemoteCommand)u).cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
            return false;
        }
        return true;
    }

    private void prepareCommit(Repository git, List<RemoteCommand> cmds, Map<String, RemoteRefUpdate> updates, Map<String, Ref> adv, ObjectId committed) throws IOException {
        for (ReceiveCommand cmd : this.prepareCommit(git, adv, committed)) {
            RemoteCommand c = new RemoteCommand(cmd);
            cmds.add(c);
            updates.put(c.getRemoteName(), c);
        }
    }

    private static List<RemoteCommand> asUpdateList(Collection<ReceiveCommand> cmds) {
        try {
            ArrayList<RemoteCommand> toPush = new ArrayList<RemoteCommand>(cmds.size());
            for (ReceiveCommand cmd : cmds) {
                toPush.add(new RemoteCommand(cmd));
            }
            return toPush;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, RemoteRefUpdate> asUpdateMap(List<RemoteCommand> cmds) {
        LinkedHashMap<String, RemoteRefUpdate> m = new LinkedHashMap<String, RemoteRefUpdate>();
        for (RemoteCommand cmd : cmds) {
            m.put(cmd.getRemoteName(), cmd);
        }
        return m;
    }

    private static void abort(List<RemoteCommand> cmds) {
        ArrayList<ReceiveCommand> tmp = new ArrayList<ReceiveCommand>(cmds.size());
        for (RemoteCommand cmd : cmds) {
            tmp.add(cmd.cmd);
        }
        ReceiveCommand.abort(tmp);
    }

    @Override
    protected void blockingFetch(Repository repo, ReplicaFetchRequest req) throws NotSupportedException, TransportException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Transport transport = Transport.open(repo, this.uri);){
            RemoteConfig rc = this.getRemoteConfig();
            if (rc != null) {
                transport.applyConfig(rc);
            }
            this.fetch(transport, req);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void fetch(Transport transport, ReplicaFetchRequest req) throws NotSupportedException, TransportException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FetchConnection conn = transport.openFetch();){
            Map<String, Ref> remoteRefs = conn.getRefsMap();
            req.setRefs(remoteRefs);
            ArrayList<Ref> want = new ArrayList<Ref>();
            for (String name : req.getWantRefs()) {
                Ref ref = remoteRefs.get(name);
                if (ref == null || ref.getObjectId() == null) continue;
                want.add(ref);
            }
            for (ObjectId id : req.getWantObjects()) {
                want.add(new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, id.name(), id));
            }
            conn.fetch(NullProgressMonitor.INSTANCE, want, Collections.emptySet());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static class RemoteCommand
    extends RemoteRefUpdate {
        final ReceiveCommand cmd;

        RemoteCommand(ReceiveCommand cmd) throws IOException {
            super(null, null, cmd.getNewId(), cmd.getRefName(), true, null, cmd.getOldId());
            this.cmd = cmd;
        }

        void copyStatusToResult() {
            if (this.cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED) {
                switch (this.getStatus()) {
                    case UP_TO_DATE: 
                    case NON_EXISTING: 
                    case OK: {
                        this.cmd.setResult(ReceiveCommand.Result.OK);
                        break;
                    }
                    case REJECTED_NODELETE: {
                        this.cmd.setResult(ReceiveCommand.Result.REJECTED_NODELETE);
                        break;
                    }
                    case REJECTED_NONFASTFORWARD: {
                        this.cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                        break;
                    }
                    case REJECTED_OTHER_REASON: {
                        this.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, this.getMessage());
                        break;
                    }
                    default: {
                        this.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, this.getStatus().name());
                    }
                }
            }
        }
    }
}

