/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.lib;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import zz.org.eclipse.jgit.errors.ConfigInvalidException;
import zz.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import zz.org.eclipse.jgit.errors.MissingObjectException;
import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.lib.AnyObjectId;
import zz.org.eclipse.jgit.lib.Config;
import zz.org.eclipse.jgit.lib.ObjectLoader;
import zz.org.eclipse.jgit.lib.ObjectReader;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.revwalk.RevCommit;
import zz.org.eclipse.jgit.revwalk.RevTree;
import zz.org.eclipse.jgit.revwalk.RevWalk;
import zz.org.eclipse.jgit.treewalk.TreeWalk;
import zz.org.eclipse.jgit.util.RawParseUtils;

public class BlobBasedConfig
extends Config {
    public BlobBasedConfig(Config base, byte[] blob) throws ConfigInvalidException {
        super(base);
        String decoded = this.isUtf8(blob) ? RawParseUtils.decode(StandardCharsets.UTF_8, blob, 3, blob.length) : RawParseUtils.decode(blob);
        this.fromText(decoded);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId objectId) throws IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, objectId));
    }

    private static byte[] read(Repository db, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectReader or = db.newObjectReader();){
            return BlobBasedConfig.read(or, blobId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] read(ObjectReader or, AnyObjectId blobId) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader loader = or.open(blobId, 3);
        return loader.getCachedBytes(Integer.MAX_VALUE);
    }

    public BlobBasedConfig(Config base, Repository db, AnyObjectId treeish, String path) throws FileNotFoundException, IOException, ConfigInvalidException {
        this(base, BlobBasedConfig.read(db, treeish, path));
    }

    private static byte[] read(Repository db, AnyObjectId treeish, String path) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectReader or = db.newObjectReader();){
            TreeWalk tree = TreeWalk.forPath(or, path, BlobBasedConfig.asTree(or, treeish));
            if (tree == null) {
                throw new FileNotFoundException(MessageFormat.format(JGitText.get().entryNotFoundByPath, path));
            }
            return BlobBasedConfig.read(or, (AnyObjectId)tree.getObjectId(0));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static AnyObjectId asTree(ObjectReader or, AnyObjectId treeish) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (treeish instanceof RevTree) {
            return treeish;
        }
        if (treeish instanceof RevCommit && ((RevCommit)treeish).getTree() != null) {
            return ((RevCommit)treeish).getTree();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk rw = new RevWalk(or);){
            return rw.parseTree(treeish).getId();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

