/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.revwalk.filter;

import zz.org.eclipse.jgit.internal.JGitText;
import zz.org.eclipse.jgit.revwalk.RevCommit;
import zz.org.eclipse.jgit.revwalk.filter.PatternMatchRevFilter;
import zz.org.eclipse.jgit.revwalk.filter.RevFilter;
import zz.org.eclipse.jgit.revwalk.filter.SubStringRevFilter;
import zz.org.eclipse.jgit.util.RawCharSequence;
import zz.org.eclipse.jgit.util.RawParseUtils;

public class MessageRevFilter {
    public static RevFilter create(String pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        if (SubStringRevFilter.safe(pattern)) {
            return new SubStringSearch(pattern);
        }
        return new PatternSearch(pattern);
    }

    private MessageRevFilter() {
    }

    static RawCharSequence textFor(RevCommit cmit) {
        byte[] raw = cmit.getRawBuffer();
        int b = RawParseUtils.commitMessage(raw, 0);
        if (b < 0) {
            return RawCharSequence.EMPTY;
        }
        return new RawCharSequence(raw, b, raw.length);
    }

    private static class PatternSearch
    extends PatternMatchRevFilter {
        PatternSearch(String patternText) {
            super(patternText, true, true, 34);
        }

        @Override
        protected CharSequence text(RevCommit cmit) {
            return MessageRevFilter.textFor(cmit);
        }

        @Override
        public RevFilter clone() {
            return new PatternSearch(this.pattern());
        }
    }

    private static class SubStringSearch
    extends SubStringRevFilter {
        SubStringSearch(String patternText) {
            super(patternText);
        }

        @Override
        protected RawCharSequence text(RevCommit cmit) {
            return MessageRevFilter.textFor(cmit);
        }
    }
}

