/*
 * Decompiled with CFR 0.152.
 */
package zz.org.eclipse.jgit.treewalk.filter;

import zz.org.eclipse.jgit.dircache.DirCacheEntry;
import zz.org.eclipse.jgit.dircache.DirCacheIterator;
import zz.org.eclipse.jgit.treewalk.TreeWalk;
import zz.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class SkipWorkTreeFilter
extends TreeFilter {
    private final int treeIdx;

    public SkipWorkTreeFilter(int treeIdx) {
        this.treeIdx = treeIdx;
    }

    @Override
    public boolean include(TreeWalk walker) {
        DirCacheIterator i = walker.getTree(this.treeIdx, DirCacheIterator.class);
        if (i == null) {
            return true;
        }
        DirCacheEntry e = i.getDirCacheEntry();
        return e == null || !e.isSkipWorkTree();
    }

    @Override
    public boolean shouldBeRecursive() {
        return false;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "SkipWorkTree(" + this.treeIdx + ")";
    }
}

