/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.version;

import java.util.Collection;
import java.util.HashSet;
import zz.org.sonatype.aether.version.Version;
import zz.org.sonatype.aether.version.VersionConstraint;
import zz.org.sonatype.aether.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GenericVersionConstraint
implements VersionConstraint {
    private Collection<VersionRange> ranges = new HashSet<VersionRange>();
    private Version version;

    GenericVersionConstraint() {
    }

    public GenericVersionConstraint addRange(VersionRange range) {
        if (range != null) {
            this.ranges.add(range);
        }
        return this;
    }

    @Override
    public Collection<VersionRange> getRanges() {
        return this.ranges;
    }

    public GenericVersionConstraint setVersion(Version version) {
        this.version = version;
        return this;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean containsVersion(Version version) {
        if (this.ranges.isEmpty()) {
            return version.equals(this.version);
        }
        for (VersionRange range : this.ranges) {
            if (!range.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        for (VersionRange range : this.getRanges()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(range);
        }
        if (buffer.length() <= 0) {
            buffer.append(this.getVersion());
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        GenericVersionConstraint that = (GenericVersionConstraint)obj;
        return ((Object)this.ranges).equals(that.getRanges()) && GenericVersionConstraint.eq(this.version, that.getVersion());
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + GenericVersionConstraint.hash(this.getRanges());
        hash = hash * 31 + GenericVersionConstraint.hash(this.getVersion());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

