/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.utility.compare;

import java.util.Objects;
import java.util.Optional;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.model.ExternalRef;
import zz.org.spdx.library.model.ReferenceType;
import zz.org.spdx.library.model.enumerations.ReferenceCategory;
import zz.org.spdx.utility.compare.SpdxComparer;

public class SpdxExternalRefDifference {
    String commentA;
    String commentB;
    ReferenceCategory catA;
    ReferenceCategory catB;
    private String referenceLocator;
    private ReferenceType referenceType;

    SpdxExternalRefDifference(ExternalRef externalRefA, ExternalRef externalRefB) throws InvalidSPDXAnalysisException {
        Optional<String> oCommentA = externalRefA.getComment();
        this.commentA = oCommentA.isPresent() ? oCommentA.get() : "";
        Optional<String> oCommentB = externalRefB.getComment();
        this.commentB = oCommentB.isPresent() ? oCommentB.get() : "";
        this.catA = externalRefA.getReferenceCategory();
        this.catB = externalRefB.getReferenceCategory();
        this.referenceLocator = externalRefA.getReferenceLocator();
        this.referenceType = externalRefA.getReferenceType();
    }

    public boolean isCommentsEqual() {
        return SpdxComparer.stringsEqual(this.commentA, this.commentB);
    }

    public boolean isReferenceCategoriesEqual() {
        return Objects.equals(this.catA, this.catB);
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public ReferenceCategory getCatA() {
        return this.catA;
    }

    public ReferenceCategory getCatB() {
        return this.catB;
    }

    public String getReferenceLocator() {
        return this.referenceLocator;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }
}

