/*
 * Decompiled with CFR 0.152.
 */
package zz.org.spdx.utility.compare;

import java.util.Collection;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.model.license.ExtractedLicenseInfo;
import zz.org.spdx.utility.compare.SpdxComparer;

public class SpdxLicenseDifference {
    private String licenseText;
    private String licenseNameA;
    private String licenseNameB;
    private boolean licenseNamesEqual;
    private String IdA;
    private String IdB;
    private String commentA;
    private String commentB;
    private boolean commentsEqual;
    private Collection<String> sourceUrlsA;
    private Collection<String> sourceUrlsB;
    private boolean sourceUrlsEqual;

    public String getLicenseText() {
        return this.licenseText;
    }

    public String getLicenseNameA() {
        return this.licenseNameA;
    }

    public String getLicenseNameB() {
        return this.licenseNameB;
    }

    public boolean isLicenseNamesEqual() {
        return this.licenseNamesEqual;
    }

    public String getIdA() {
        return this.IdA;
    }

    public String getIdB() {
        return this.IdB;
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public boolean isCommentsEqual() {
        return this.commentsEqual;
    }

    public Collection<String> getSourceUrlsA() {
        return this.sourceUrlsA;
    }

    public Collection<String> getSourceUrlsB() {
        return this.sourceUrlsB;
    }

    public boolean isSourceUrlsEqual() {
        return this.sourceUrlsEqual;
    }

    public SpdxLicenseDifference(ExtractedLicenseInfo licenseA, ExtractedLicenseInfo licenseB) throws InvalidSPDXAnalysisException {
        this.licenseText = licenseA.getExtractedText();
        this.licenseNameA = licenseA.getName();
        this.licenseNameB = licenseB.getName();
        this.licenseNamesEqual = SpdxComparer.stringsEqual(this.licenseNameA, this.licenseNameB);
        this.IdA = licenseA.getLicenseId();
        this.IdB = licenseB.getLicenseId();
        this.commentA = licenseA.getComment();
        this.commentB = licenseB.getComment();
        this.commentsEqual = SpdxComparer.stringsEqual(this.commentA, this.commentB);
        this.sourceUrlsA = licenseA.getSeeAlso();
        this.sourceUrlsB = licenseB.getSeeAlso();
        this.sourceUrlsEqual = SpdxComparer.stringCollectionsEqual(this.sourceUrlsA, this.sourceUrlsB);
    }
}

