/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tomlj;

import java.time.DateTimeException;
import java.time.LocalDate;
import zz.org.antlr.v4.runtime.tree.ErrorNode;
import zz.org.tomlj.TomlParseError;
import zz.org.tomlj.TomlPosition;
import zz.org.tomlj.internal.TomlParser;
import zz.org.tomlj.internal.TomlParserBaseVisitor;

final class LocalDateVisitor
extends TomlParserBaseVisitor<LocalDate> {
    private static LocalDate INITIAL = LocalDate.parse("1900-01-01");
    private LocalDate date = INITIAL;

    LocalDateVisitor() {
    }

    @Override
    public LocalDate visitYear(TomlParser.YearContext ctx) {
        int year;
        String text = ctx.getText();
        if (text.length() != 4) {
            throw new TomlParseError("Invalid year (valid range 0000..9999)", new TomlPosition(ctx));
        }
        try {
            year = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid year", new TomlPosition(ctx), e);
        }
        this.date = this.date.withYear(year);
        return this.date;
    }

    @Override
    public LocalDate visitMonth(TomlParser.MonthContext ctx) {
        int month;
        String text = ctx.getText();
        if (text.length() != 2) {
            throw new TomlParseError("Invalid month (valid range 01..12)", new TomlPosition(ctx));
        }
        try {
            month = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid month", new TomlPosition(ctx), e);
        }
        if (month < 1 || month > 12) {
            throw new TomlParseError("Invalid month (valid range 01..12)", new TomlPosition(ctx));
        }
        this.date = this.date.withMonth(month);
        return this.date;
    }

    @Override
    public LocalDate visitDay(TomlParser.DayContext ctx) {
        int day;
        String text = ctx.getText();
        if (text.length() != 2) {
            throw new TomlParseError("Invalid day (valid range 01..28/31)", new TomlPosition(ctx));
        }
        try {
            day = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new TomlParseError("Invalid day", new TomlPosition(ctx), e);
        }
        if (day < 1 || day > 31) {
            throw new TomlParseError("Invalid day (valid range 01..28/31)", new TomlPosition(ctx));
        }
        try {
            this.date = this.date.withDayOfMonth(day);
        }
        catch (DateTimeException e) {
            throw new TomlParseError(e.getMessage(), new TomlPosition(ctx), e);
        }
        return this.date;
    }

    @Override
    public LocalDate visitErrorNode(ErrorNode node) {
        return null;
    }

    @Override
    protected LocalDate aggregateResult(LocalDate aggregate, LocalDate nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected LocalDate defaultResult() {
        return this.date;
    }
}

