/*
 * Decompiled with CFR 0.152.
 */
package zz.org.zeroturnaround.exec.stream.slf4j;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.zeroturnaround.exec.stream.CallerLoggerUtil;
import zz.org.zeroturnaround.exec.stream.slf4j.Level;
import zz.org.zeroturnaround.exec.stream.slf4j.Slf4jDebugOutputStream;
import zz.org.zeroturnaround.exec.stream.slf4j.Slf4jErrorOutputStream;
import zz.org.zeroturnaround.exec.stream.slf4j.Slf4jInfoOutputStream;
import zz.org.zeroturnaround.exec.stream.slf4j.Slf4jOutputStream;
import zz.org.zeroturnaround.exec.stream.slf4j.Slf4jTraceOutputStream;
import zz.org.zeroturnaround.exec.stream.slf4j.Slf4jWarnOutputStream;

public class Slf4jStream {
    private final Logger log;

    private Slf4jStream(Logger log) {
        this.log = log;
    }

    public static Slf4jStream of(Logger log) {
        return new Slf4jStream(log);
    }

    public static Slf4jStream of(Class<?> klass) {
        return Slf4jStream.of(LoggerFactory.getLogger(klass));
    }

    public static Slf4jStream of(Class<?> klass, String name) {
        if (name == null) {
            return Slf4jStream.of(klass);
        }
        return Slf4jStream.of(LoggerFactory.getLogger((String)(klass.getName() + "." + name)));
    }

    public static Slf4jStream of(String name) {
        return Slf4jStream.of(LoggerFactory.getLogger((String)CallerLoggerUtil.getName(name, 1)));
    }

    public static Slf4jStream ofCaller() {
        return Slf4jStream.of(LoggerFactory.getLogger((String)CallerLoggerUtil.getName(null, 1)));
    }

    public Slf4jOutputStream as(Level level) {
        switch (level) {
            case TRACE: {
                return this.asTrace();
            }
            case DEBUG: {
                return this.asDebug();
            }
            case INFO: {
                return this.asInfo();
            }
            case WARN: {
                return this.asWarn();
            }
            case ERROR: {
                return this.asError();
            }
        }
        throw new IllegalArgumentException("Invalid level " + (Object)((Object)level));
    }

    public Slf4jOutputStream asTrace() {
        return new Slf4jTraceOutputStream(this.log);
    }

    public Slf4jOutputStream asDebug() {
        return new Slf4jDebugOutputStream(this.log);
    }

    public Slf4jOutputStream asInfo() {
        return new Slf4jInfoOutputStream(this.log);
    }

    public Slf4jOutputStream asWarn() {
        return new Slf4jWarnOutputStream(this.log);
    }

    public Slf4jOutputStream asError() {
        return new Slf4jErrorOutputStream(this.log);
    }
}

