/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AlpineDependency {
    private static final Pattern NAME_VERSION_PATTERN = Pattern.compile("(?<name>\\S+?)(-)(?<version>[0-9](.*))");
    private final String name;
    private final String version;

    public AlpineDependency(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public static AlpineDependency fromContent(String content) {
        Matcher matcher = NAME_VERSION_PATTERN.matcher(content);
        if (matcher.find()) {
            return new AlpineDependency(matcher.group("name").trim(), matcher.group("version").trim());
        }
        return null;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof AlpineDependency)) {
            return false;
        }
        AlpineDependency otherAlpineDependency = (AlpineDependency)otherObject;
        return Objects.equals(this.name, otherAlpineDependency.name) && Objects.equals(this.version, otherAlpineDependency.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        return this.name + "-" + this.version;
    }
}

