/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.Objects;

public final class GoDependency {
    private String name;
    private String version;

    public static GoDependency fromGoModString(String line) {
        String[] parts = line.trim().split("\\s+");
        if (parts.length > 1) {
            String name = parts[0];
            name = name.replaceAll("/+$", "");
            String version = parts[1].replace("/go.mod", "");
            return new GoDependency(name, version);
        }
        return null;
    }

    private GoDependency(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoDependency that = (GoDependency)o;
        return this.name.equals(that.name) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        return (this.name + " " + this.version).trim();
    }
}

