/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.Version;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.RelatedElementCollection;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxItem;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.OrLaterOperator;
import org.spdx.library.model.license.SimpleLicensingInfo;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.library.model.license.SpdxNoneLicense;
import org.spdx.library.model.license.WithExceptionOperator;
import org.spdx.storage.IModelStore;

public class SpdxPackage
extends SpdxItem
implements Comparable<SpdxPackage> {
    Collection<SpdxElement> files = new RelatedElementCollection(this, RelationshipType.CONTAINS, "File");

    public SpdxPackage() throws InvalidSPDXAnalysisException {
    }

    public SpdxPackage(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public SpdxPackage(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    protected SpdxPackage(SpdxPackageBuilder spdxPackageBuilder) throws InvalidSPDXAnalysisException {
        this(spdxPackageBuilder.modelStore, spdxPackageBuilder.documentUri, spdxPackageBuilder.id, spdxPackageBuilder.copyManager, true);
        this.setFilesAnalyzed(spdxPackageBuilder.filesAnalyzed);
        this.setCopyrightText(spdxPackageBuilder.copyrightText);
        this.setName(spdxPackageBuilder.name);
        this.setLicenseConcluded(spdxPackageBuilder.concludedLicense);
        this.setLicenseDeclared(spdxPackageBuilder.licenseDeclared);
        this.getAnnotations().addAll(spdxPackageBuilder.annotations);
        this.getRelationships().addAll(spdxPackageBuilder.relationships);
        this.setComment(spdxPackageBuilder.comment);
        this.setLicenseComments(spdxPackageBuilder.licenseComments);
        this.getLicenseInfoFromFiles().addAll(spdxPackageBuilder.licenseInfosFromFile);
        this.getAttributionText().addAll(spdxPackageBuilder.attributionText);
        this.getChecksums().addAll(spdxPackageBuilder.checksums);
        this.setDescription(spdxPackageBuilder.description);
        this.setDownloadLocation(spdxPackageBuilder.downloadLocation);
        this.getExternalRefs().addAll(spdxPackageBuilder.externalRefs);
        this.getFiles().addAll(spdxPackageBuilder.files);
        this.setHomepage(spdxPackageBuilder.homepage);
        this.setOriginator(spdxPackageBuilder.originator);
        this.setPackageFileName(spdxPackageBuilder.pacakgeFileName);
        this.setPackageVerificationCode(spdxPackageBuilder.packageVerificationCode);
        this.setSourceInfo(spdxPackageBuilder.sourceInfo);
        this.setSummary(spdxPackageBuilder.summary);
        this.setSupplier(spdxPackageBuilder.supplier);
        this.setVersionInfo(spdxPackageBuilder.versionInfo);
        this.setPrimaryPurpose(spdxPackageBuilder.primaryPurpose);
        this.setBuiltDate(spdxPackageBuilder.builtDate);
        this.setValidUntilDate(spdxPackageBuilder.validUntilDate);
        this.setReleaseDate(spdxPackageBuilder.releaseDate);
    }

    @Override
    public String getType() {
        return "Package";
    }

    @Override
    protected String getNamePropertyName() {
        return "name";
    }

    public boolean isFilesAnalyzed() throws InvalidSPDXAnalysisException {
        Optional<Boolean> filesAnalyzed = this.getBooleanPropertyValue("filesAnalyzed");
        if (!filesAnalyzed.isPresent()) {
            return true;
        }
        return filesAnalyzed.get();
    }

    public SpdxPackage setFilesAnalyzed(@Nullable Boolean filesAnalyzed) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("filesAnalyzed", filesAnalyzed);
        return this;
    }

    public Optional<String> getBuiltDate() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("builtDate");
    }

    public void setBuiltDate(String builtDate) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.nonNull(builtDate) && Objects.nonNull(SpdxVerificationHelper.verifyDate(builtDate))) {
            throw new InvalidSPDXAnalysisException("Invalid built date");
        }
        this.setPropertyValue("builtDate", builtDate);
    }

    public Optional<String> getReleaseDate() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("releaseDate");
    }

    public void setReleaseDate(String releaseDate) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.nonNull(releaseDate) && Objects.nonNull(SpdxVerificationHelper.verifyDate(releaseDate))) {
            throw new InvalidSPDXAnalysisException("Invalid release date");
        }
        this.setPropertyValue("releaseDate", releaseDate);
    }

    public Optional<String> getValidUntilDate() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("validUntilDate");
    }

    public void setValidUntilDate(String validUntilDate) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.nonNull(validUntilDate) && Objects.nonNull(SpdxVerificationHelper.verifyDate(validUntilDate))) {
            throw new InvalidSPDXAnalysisException("Invalid valid until date");
        }
        this.setPropertyValue("validUntilDate", validUntilDate);
    }

    @Nullable
    public AnyLicenseInfo getLicenseDeclared() throws InvalidSPDXAnalysisException {
        Optional<AnyLicenseInfo> retval = this.getAnyLicenseInfoPropertyValue("licenseDeclared");
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("No declared license provided - returning NoAssertion");
        return new SpdxNoAssertionLicense();
    }

    public SpdxPackage setLicenseDeclared(@Nullable AnyLicenseInfo licenseDeclared) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseDeclared", licenseDeclared);
        return this;
    }

    public Collection<Checksum> getChecksums() throws InvalidSPDXAnalysisException {
        return this.getObjectPropertyValueSet("checksum", Checksum.class);
    }

    public SpdxPackage addChecksum(Checksum checksum) throws InvalidSPDXAnalysisException {
        this.getChecksums().add(checksum);
        return this;
    }

    public Optional<String> getDescription() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("description");
    }

    public SpdxPackage setDescription(String description) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("description", description);
        return this;
    }

    public Optional<String> getDownloadLocation() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("downloadLocation");
    }

    public SpdxPackage setDownloadLocation(String downloadLocation) throws InvalidSPDXAnalysisException {
        String verify;
        if (this.strict && Objects.nonNull(downloadLocation) && Objects.nonNull(verify = SpdxVerificationHelper.verifyDownloadLocation(downloadLocation)) && !verify.isEmpty()) {
            throw new InvalidSPDXAnalysisException(verify);
        }
        this.setPropertyValue("downloadLocation", downloadLocation);
        return this;
    }

    public Optional<String> getHomepage() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("homepage");
    }

    public SpdxPackage setHomepage(String homepage) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.nonNull(homepage) && !SpdxVerificationHelper.isValidUri(homepage)) {
            throw new InvalidSPDXAnalysisException(homepage + " is not a valid URI");
        }
        this.setPropertyValue("homepage", homepage);
        return this;
    }

    public Optional<String> getOriginator() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("originator");
    }

    public SpdxPackage setOriginator(String originator) throws InvalidSPDXAnalysisException {
        String verify;
        if (this.strict && Objects.nonNull(originator) && Objects.nonNull(verify = SpdxVerificationHelper.verifyOriginator(originator)) && !verify.isEmpty()) {
            throw new InvalidSPDXAnalysisException(verify);
        }
        this.setPropertyValue("originator", originator);
        return this;
    }

    public Optional<String> getPackageFileName() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("packageFileName");
    }

    public SpdxPackage setPackageFileName(String packageFileName) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("packageFileName", packageFileName);
        return this;
    }

    public Optional<SpdxPackageVerificationCode> getPackageVerificationCode() throws InvalidSPDXAnalysisException {
        Optional<Object> retval = this.getObjectPropertyValue("packageVerificationCode");
        if (!retval.isPresent()) {
            return Optional.empty();
        }
        if (!(retval.get() instanceof SpdxPackageVerificationCode)) {
            throw new InvalidSPDXAnalysisException("Invalid type - expecting SpdxVerificationCode, type was " + retval.get().getClass().toString());
        }
        return Optional.of((SpdxPackageVerificationCode)retval.get());
    }

    public SpdxPackage setPackageVerificationCode(SpdxPackageVerificationCode verificationCode) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull(verificationCode) && this.isFilesAnalyzed()) {
            throw new InvalidSPDXAnalysisException("Can not set required verificationCode to null");
        }
        this.setPropertyValue("packageVerificationCode", verificationCode);
        return this;
    }

    public Optional<String> getSourceInfo() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("sourceInfo");
    }

    public SpdxPackage setSourceInfo(String sourceInfo) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("sourceInfo", sourceInfo);
        return this;
    }

    public Optional<String> getSummary() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("summary");
    }

    public SpdxPackage setSummary(String summary) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("summary", summary);
        return this;
    }

    public Optional<String> getSupplier() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("supplier");
    }

    public SpdxPackage setSupplier(String supplier) throws InvalidSPDXAnalysisException {
        String verify;
        if (Objects.nonNull(supplier) && this.strict && Objects.nonNull(verify = SpdxVerificationHelper.verifySupplier(supplier)) && !verify.isEmpty()) {
            throw new InvalidSPDXAnalysisException(verify);
        }
        this.setPropertyValue("supplier", supplier);
        return this;
    }

    public Optional<String> getVersionInfo() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("versionInfo");
    }

    public SpdxPackage setVersionInfo(String versionInfo) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("versionInfo", versionInfo);
        return this;
    }

    public Collection<ExternalRef> getExternalRefs() throws InvalidSPDXAnalysisException {
        return this.getObjectPropertyValueSet("externalRef", ExternalRef.class);
    }

    public SpdxPackage addExternalRef(ExternalRef externalRef) throws InvalidSPDXAnalysisException {
        this.getExternalRefs().add(externalRef);
        return this;
    }

    public Collection<SpdxFile> getFiles() throws InvalidSPDXAnalysisException {
        return this.files;
    }

    public SpdxPackage addFile(SpdxFile file) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(file)) {
            throw new InvalidSPDXAnalysisException("Can not add null file to a package");
        }
        this.getFiles().add(file);
        return this;
    }

    public Optional<Purpose> getPrimaryPurpose() throws InvalidSPDXAnalysisException {
        Optional<Enum<?>> retval = this.getEnumPropertyValue("primaryPackagePurpose");
        if (retval.isPresent() && !(retval.get() instanceof Purpose)) {
            throw new SpdxInvalidTypeException("Invalid enum type for " + retval.get().toString());
        }
        return retval;
    }

    public void setPrimaryPurpose(Purpose purpose) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("primaryPackagePurpose", purpose);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        String err;
        Optional<String> date;
        String error;
        List<String> verify;
        List<String> retval = super._verify(verifiedIds, specVersion);
        String pkgName = "UNKNOWN PACKAGE";
        try {
            Optional<String> name = this.getName();
            pkgName = name.isPresent() ? name.get() : "UNKNOWN PACKAGE";
        }
        catch (InvalidSPDXAnalysisException e1) {
            retval.add("Unable to get package name: " + e1.getMessage());
        }
        boolean filesAnalyzed = true;
        try {
            filesAnalyzed = this.isFilesAnalyzed();
        }
        catch (InvalidSPDXAnalysisException e1) {
            retval.add("Unable to get filesAnalyzed: " + e1.getMessage());
        }
        try {
            Optional<String> downloadLocation = this.getDownloadLocation();
            if (!downloadLocation.isPresent() || downloadLocation.get().isEmpty()) {
                retval.add("Missing required download location for package " + pkgName);
            } else {
                String warning = SpdxVerificationHelper.verifyDownloadLocation(downloadLocation.get());
                if (Objects.nonNull(warning)) {
                    retval.add(warning);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e1) {
            retval.add("Unable to get download location: " + e1.getMessage());
        }
        try {
            for (Checksum checksum : this.getChecksums()) {
                List<String> checksumVerify = checksum.verify(verifiedIds, specVersion);
                this.addNameToWarnings(checksumVerify);
                retval.addAll(checksumVerify);
            }
        }
        catch (InvalidSPDXAnalysisException e1) {
            retval.add("Unable to get checksums: " + e1.getMessage());
        }
        try {
            Optional<AnyLicenseInfo> declaredLicense = this.getAnyLicenseInfoPropertyValue("licenseDeclared");
            if (!declaredLicense.isPresent()) {
                if (Version.versionLessThan(specVersion, "SPDX-2.3")) {
                    retval.add("Missing required declared license for package " + pkgName);
                }
            } else {
                verify = declaredLicense.get().verify(verifiedIds, specVersion);
                this.addNameToWarnings(verify);
                retval.addAll(verify);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid package declared license: " + e.getMessage());
        }
        try {
            this.verifyLicenseInfosInFiles(this.getLicenseInfoFromFiles(), filesAnalyzed, pkgName, verifiedIds, retval, specVersion);
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid license infos from file: " + e.getMessage());
        }
        try {
            if (this.getFiles().size() == 0) {
                if (filesAnalyzed) {
                    retval.add("Missing required package files for " + pkgName);
                }
            } else {
                if (!filesAnalyzed) {
                    retval.add("Warning: Found analyzed files for package " + pkgName + " when analyzedFiles is set to false.");
                }
                for (SpdxFile file : this.getFiles()) {
                    List<String> verify2 = file.verify(verifiedIds, specVersion);
                    this.addNameToWarnings(verify2);
                    retval.addAll(verify2);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid package files: " + e.getMessage());
        }
        try {
            Optional<SpdxPackageVerificationCode> verificationCode = this.getPackageVerificationCode();
            if (!verificationCode.isPresent() && filesAnalyzed) {
                retval.add("Missing required package verification code for package " + pkgName);
            } else if (verificationCode.isPresent() && !verificationCode.get().getValue().isEmpty() && !filesAnalyzed) {
                retval.add("Verification code must not be included when files not analyzed.");
            } else if (filesAnalyzed) {
                verify = verificationCode.get().verify(verifiedIds, specVersion);
                this.addNameToWarnings(verify);
                retval.addAll(verify);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid package verification code: " + e.getMessage());
        }
        try {
            Optional<String> supplier = this.getSupplier();
            if (supplier.isPresent() && !supplier.get().isEmpty() && (error = SpdxVerificationHelper.verifySupplier(supplier.get())) != null && !error.isEmpty()) {
                retval.add("Supplier error - " + error + " for package " + pkgName);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid supplier: " + e.getMessage());
        }
        try {
            Optional<String> originator = this.getOriginator();
            if (originator.isPresent() && !originator.get().isEmpty() && (error = SpdxVerificationHelper.verifyOriginator(originator.get())) != null && !error.isEmpty()) {
                retval.add("Originator error - " + error + " for package " + pkgName);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid originator: " + e.getMessage());
        }
        try {
            for (ExternalRef externalRef : this.getExternalRefs()) {
                retval.addAll(externalRef.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid external refs: " + e.getMessage());
        }
        try {
            date = this.getBuiltDate();
            if (date.isPresent()) {
                err = SpdxVerificationHelper.verifyDate(date.get());
                if (Objects.nonNull(err)) {
                    retval.add("Invalid built date: " + err);
                }
                if (Version.versionLessThan(specVersion, "SPDX-2.3")) {
                    retval.add("Built date is not supported prior to release SPDX-2.3");
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting built date");
        }
        try {
            date = this.getReleaseDate();
            if (date.isPresent()) {
                err = SpdxVerificationHelper.verifyDate(date.get());
                if (Objects.nonNull(err)) {
                    retval.add("Invalid releaes date: " + err);
                }
                if (Version.versionLessThan(specVersion, "SPDX-2.3")) {
                    retval.add("Release date is not supported prior to release SPDX-2.3");
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting release date");
        }
        try {
            date = this.getValidUntilDate();
            if (date.isPresent()) {
                err = SpdxVerificationHelper.verifyDate(date.get());
                if (Objects.nonNull(err)) {
                    retval.add("Invalid valid until date: " + err);
                }
                if (Version.versionLessThan(specVersion, "SPDX-2.3")) {
                    retval.add("Valid until date is not supported prior to release SPDX-2.3");
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting valid until date");
        }
        try {
            Optional<Purpose> purpose = this.getPrimaryPurpose();
            if (purpose.isPresent() && Version.versionLessThan(specVersion, "SPDX-2.3")) {
                retval.add("Primary purpose is not supported prior to release SPDX-2.3");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting primary purpose");
        }
        return retval;
    }

    private void verifyLicenseInfosInFiles(Collection<AnyLicenseInfo> licenseInfoFromFiles, boolean filesAnalyzed, String pkgName, Set<String> verifiedIds, List<String> retval, String specVersion) {
        if (licenseInfoFromFiles.size() == 0 && filesAnalyzed) {
            if (Version.versionLessThan(specVersion, "SPDX-2.3")) {
                retval.add("Missing required license information from files for " + pkgName);
            }
        } else {
            boolean foundNonSimpleLic = false;
            for (AnyLicenseInfo lic : licenseInfoFromFiles) {
                List<String> verify = lic.verify(verifiedIds, specVersion);
                this.addNameToWarnings(verify);
                retval.addAll(verify);
                if (lic instanceof SimpleLicensingInfo || lic instanceof SpdxNoAssertionLicense || lic instanceof SpdxNoneLicense || lic instanceof OrLaterOperator || lic instanceof WithExceptionOperator) continue;
                foundNonSimpleLic = true;
            }
            if (foundNonSimpleLic) {
                retval.add("license info from files contains complex licenses for " + pkgName);
            }
        }
    }

    @Override
    public int compareTo(SpdxPackage pkg) {
        String myNameVersion = "";
        String compNameVersion = "";
        try {
            Optional<String> myName = this.getName();
            myNameVersion = myName.isPresent() ? myName.get() : "";
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting my name", (Throwable)e);
        }
        try {
            Optional<String> compName = pkg.getName();
            compNameVersion = compName.isPresent() ? compName.get() : "";
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting compare name", (Throwable)e);
        }
        try {
            Optional<String> myVersion = this.getVersionInfo();
            if (myVersion.isPresent()) {
                myNameVersion = myNameVersion + myVersion.get();
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting my version", (Throwable)e);
        }
        try {
            Optional<String> compVersion = pkg.getVersionInfo();
            if (compVersion.isPresent()) {
                compNameVersion = compNameVersion + compVersion.get();
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting compare version", (Throwable)e);
        }
        return myNameVersion.compareToIgnoreCase(compNameVersion);
    }

    public String getSha1() throws InvalidSPDXAnalysisException {
        for (Checksum checksum : this.getChecksums()) {
            String value;
            if (!checksum.getAlgorithm().equals(ChecksumAlgorithm.SHA1) || (value = checksum.getValue()).isEmpty()) continue;
            return value;
        }
        return "";
    }

    public static class SpdxPackageBuilder {
        IModelStore modelStore;
        String documentUri;
        String id;
        ModelCopyManager copyManager;
        String name;
        AnyLicenseInfo concludedLicense;
        String copyrightText;
        AnyLicenseInfo licenseDeclared;
        Collection<Annotation> annotations = new ArrayList<Annotation>();
        Collection<Relationship> relationships = new ArrayList<Relationship>();
        String comment = null;
        Collection<AnyLicenseInfo> licenseInfosFromFile = new ArrayList<AnyLicenseInfo>();
        String licenseComments = null;
        Collection<String> attributionText = new ArrayList<String>();
        Collection<Checksum> checksums = new ArrayList<Checksum>();
        String description = null;
        String downloadLocation = null;
        Collection<ExternalRef> externalRefs = new ArrayList<ExternalRef>();
        Collection<SpdxFile> files = new ArrayList<SpdxFile>();
        String homepage = null;
        String originator = null;
        String pacakgeFileName = null;
        SpdxPackageVerificationCode packageVerificationCode = null;
        String sourceInfo = null;
        String summary = null;
        String supplier = null;
        String versionInfo = null;
        boolean filesAnalyzed = true;
        Purpose primaryPurpose = null;
        String builtDate = null;
        String releaseDate = null;
        String validUntilDate = null;

        public SpdxPackageBuilder(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, String name, AnyLicenseInfo concludedLicense, String copyrightText, AnyLicenseInfo licenseDeclared) {
            Objects.requireNonNull(modelStore, "Model store can not be null");
            Objects.requireNonNull(documentUri, "Document URI can not be null");
            Objects.requireNonNull(id, "ID can not be null");
            Objects.requireNonNull(name, "Name can not be null");
            this.modelStore = modelStore;
            this.documentUri = documentUri;
            this.id = id;
            this.name = name;
            this.concludedLicense = concludedLicense;
            this.copyrightText = copyrightText;
            this.licenseDeclared = licenseDeclared;
            this.copyManager = copyManager;
        }

        public SpdxPackageBuilder setAnnotations(Collection<Annotation> annotations) {
            Objects.requireNonNull(annotations, "Annotations can not be null");
            this.annotations = annotations;
            return this;
        }

        public SpdxPackageBuilder addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation, "Annotation can not be null");
            this.annotations.add(annotation);
            return this;
        }

        public SpdxPackageBuilder setRelationships(Collection<Relationship> relationships) {
            Objects.requireNonNull(relationships, "Relationships can not be null");
            this.relationships = relationships;
            return this;
        }

        public SpdxPackageBuilder addRelationship(Relationship relationship) {
            Objects.requireNonNull(relationship, "Relationship can not be null");
            this.relationships.add(relationship);
            return this;
        }

        public SpdxPackageBuilder setComment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public SpdxPackageBuilder setLicenseInfosFromFile(Collection<AnyLicenseInfo> licenseInfosFromFile) {
            this.licenseInfosFromFile = licenseInfosFromFile;
            return this;
        }

        public SpdxPackageBuilder addLicenseInfosFromFile(AnyLicenseInfo licenseInfo) {
            this.licenseInfosFromFile.add(licenseInfo);
            return this;
        }

        public SpdxPackageBuilder setLicenseComments(@Nullable String licenseComments) {
            this.licenseComments = licenseComments;
            return this;
        }

        public SpdxPackageBuilder setChecksums(Collection<Checksum> checksums) {
            Objects.requireNonNull(checksums, "Checksums can not be null");
            this.checksums = checksums;
            return this;
        }

        public SpdxPackageBuilder addChecksum(Checksum checksum) {
            Objects.requireNonNull(checksum, "Checksum can not be null");
            this.checksums.add(checksum);
            return this;
        }

        public SpdxPackageBuilder setDescription(String description) {
            Objects.requireNonNull(description, "Description can not be null");
            this.description = description;
            return this;
        }

        public SpdxPackageBuilder setExternalRefs(Collection<ExternalRef> externalRefs) {
            Objects.requireNonNull(externalRefs, "External Refs can not be null");
            this.externalRefs = externalRefs;
            return this;
        }

        public SpdxPackageBuilder addExternalRef(ExternalRef externalRef) {
            Objects.requireNonNull(externalRef, "External ref can not be null");
            this.externalRefs.add(externalRef);
            return this;
        }

        public SpdxPackageBuilder setFiles(Collection<SpdxFile> files) {
            Objects.requireNonNull(files, "Files can not be null");
            this.files = files;
            return this;
        }

        public SpdxPackageBuilder addFile(SpdxFile file) {
            Objects.requireNonNull(file, "File can not be null");
            this.files.add(file);
            return this;
        }

        public SpdxPackageBuilder setHomepage(String homepage) {
            Objects.requireNonNull(homepage, "Homepage can not be null");
            this.homepage = homepage;
            return this;
        }

        public SpdxPackageBuilder setOriginator(String originator) {
            Objects.requireNonNull(originator, "Orinator can not be null");
            this.originator = originator;
            return this;
        }

        public SpdxPackageBuilder setPackageFileName(String packageFileName) {
            Objects.requireNonNull(packageFileName, "Package file name can not be null");
            this.pacakgeFileName = packageFileName;
            return this;
        }

        public SpdxPackageBuilder setPackageVerificationCode(SpdxPackageVerificationCode packageVerificationCode) {
            Objects.requireNonNull(packageVerificationCode, "Package verification code can not be null");
            this.packageVerificationCode = packageVerificationCode;
            return this;
        }

        public SpdxPackageBuilder setSourceInfo(String sourceInfo) {
            Objects.requireNonNull(sourceInfo, "Source info can not be null");
            this.sourceInfo = sourceInfo;
            return this;
        }

        public SpdxPackageBuilder setSummary(String summary) {
            Objects.requireNonNull(summary, "Summary can not be null");
            this.summary = summary;
            return this;
        }

        public SpdxPackageBuilder setSupplier(String supplier) {
            Objects.requireNonNull(supplier, "Supplier can not be null");
            this.supplier = supplier;
            return this;
        }

        public SpdxPackageBuilder setVersionInfo(String versionInfo) {
            Objects.requireNonNull(versionInfo, "Version can not be null");
            this.versionInfo = versionInfo;
            return this;
        }

        public SpdxPackageBuilder setFilesAnalyzed(boolean filesAnalyzed) {
            this.filesAnalyzed = filesAnalyzed;
            return this;
        }

        public SpdxPackageBuilder setDownloadLocation(String downloadLocation) {
            Objects.requireNonNull(downloadLocation, "Download location can not be null");
            this.downloadLocation = downloadLocation;
            return this;
        }

        public SpdxPackageBuilder setAttributionText(Collection<String> attributionText) {
            Objects.requireNonNull(attributionText, "Attribution text collection can not be null");
            this.attributionText = attributionText;
            return this;
        }

        public SpdxPackageBuilder addAttributionText(String attribution) {
            Objects.requireNonNull(this.attributionText, "Attribution text can not be null");
            this.attributionText.add(attribution);
            return this;
        }

        public SpdxPackageBuilder setPrimaryPurpose(Purpose purpose) {
            Objects.requireNonNull(purpose, "Purpose can not be null");
            this.primaryPurpose = purpose;
            return this;
        }

        public SpdxPackageBuilder setBuiltDate(String builtDate) {
            Objects.requireNonNull(builtDate, "Built date can not be null");
            this.builtDate = builtDate;
            return this;
        }

        public SpdxPackageBuilder setValidUntilDate(String validUntilDate) {
            Objects.requireNonNull(validUntilDate, "Valid until date can not be null");
            this.validUntilDate = validUntilDate;
            return this;
        }

        public SpdxPackageBuilder setReleaseDate(String releaseDate) {
            Objects.requireNonNull(releaseDate, "Release date can not be null");
            this.releaseDate = releaseDate;
            return this;
        }

        public SpdxPackage build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.modelStore.enterCriticalSection(this.documentUri, false);
            try {
                SpdxPackage spdxPackage = new SpdxPackage(this);
                return spdxPackage;
            }
            finally {
                this.modelStore.leaveCriticalSection(lock);
            }
        }
    }
}

