/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

class HashArrayConverter
extends AbstractSingleValueConverter {
    HashArrayConverter() {
    }

    public boolean canConvert(Class type) {
        return String[].class.equals((Object)type);
    }

    public Object fromString(String str) {
        if (str == null || str.isEmpty()) {
            return new String[0];
        }
        return str.split(",");
    }

    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        String[] arr = (String[])obj;
        StringBuilder buffer = new StringBuilder(1024);
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(arr[i]);
        }
        return buffer.toString();
    }
}

