/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.io.XStreamFactory;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ScanReader {
    private final Logger log;
    private final XStream xstream;

    @Inject
    public ScanReader() {
        this(LoggerFactory.getLogger(ScanReader.class));
    }

    public ScanReader(Logger log) {
        this.log = log;
        this.xstream = XStreamFactory.newInstance();
    }

    public Scan read(File file) throws IOException {
        this.log.info("Reading scan data from {}", (Object)file);
        try (GZIPInputStream fis = new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            Scan scan = this.read(fis);
            return scan;
        }
    }

    public Scan read(InputStream in) throws IOException {
        try {
            Object root = this.xstream.fromXML(in);
            if (!(root instanceof Scan)) {
                throw new IOException("Corrupted scan file, got unexpected root element " + root.getClass().getName());
            }
            return (Scan)root;
        }
        catch (XStreamException e) {
            throw new IOException("Unsupported scan file format", e);
        }
    }
}

