/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.Dependency;
import com.sonatype.insight.scan.model.DirectoryScanItem;
import com.sonatype.insight.scan.model.ProjectScanItem;
import com.sonatype.insight.scan.model.Repository;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.ScanMetadata;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.HashArrayConverter;
import com.sonatype.insight.scan.model.io.IgnoreDefaultsPropertiesConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.io.Writer;
import java.lang.reflect.Field;

public class XStreamFactory {
    public static XStream newInstance() {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new Xpp3Driver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriter(out, this.getNameCoder()){

                    protected void writeAttributeValue(QuickWriter writer, String text) {
                        super.writeAttributeValue(writer, this.removeNullCharacter(text));
                    }

                    protected void writeText(QuickWriter writer, String text) {
                        super.writeText(writer, this.removeNullCharacter(text));
                    }

                    private String removeNullCharacter(String s) {
                        return s.replace("\u0000", "");
                    }
                };
            }
        });
        xstream.addPermission(NoTypePermission.NONE);
        xstream.allowTypeHierarchy(ScanItem.class);
        xstream.allowTypeHierarchy(Scan.class);
        xstream.allowTypeHierarchy(ScanSummary.class);
        xstream.allowTypeHierarchy(ScanConfiguration.class);
        xstream.allowTypeHierarchy(Dependency.class);
        xstream.allowTypeHierarchy(ArtifactId.class);
        xstream.allowTypeHierarchy(Repository.class);
        xstream.allowTypeHierarchy(ScanMetadata.class);
        xstream.setClassLoader(XStreamFactory.class.getClassLoader());
        xstream.alias("scan", Scan.class);
        xstream.alias("summary", ScanSummary.class);
        xstream.alias("configuration", ScanConfiguration.class);
        xstream.alias("item", ScanItem.class);
        xstream.alias("dir", DirectoryScanItem.class);
        xstream.alias("project", ProjectScanItem.class);
        xstream.alias("dep", Dependency.class);
        xstream.alias("id", ArtifactId.class);
        xstream.alias("repository", Repository.class);
        xstream.alias("metadata", ScanMetadata.class);
        xstream.addImplicitCollection(Scan.class, "items");
        xstream.addImplicitCollection(DirectoryScanItem.class, "items");
        xstream.addImplicitCollection(Dependency.class, "dependencies");
        xstream.addImplicitCollection(ScanSummary.class, "ipAddresses", "ipAddress", String.class);
        HashArrayConverter hashArrayConverter = new HashArrayConverter();
        xstream.useAttributeFor(Scan.class, "version");
        xstream.useAttributeFor(ScanItem.class, "path");
        xstream.useAttributeFor(ScanItem.class, "noPathReason");
        xstream.useAttributeFor(ScanItem.class, "proprietary");
        xstream.useAttributeFor(ScanItem.class, "size");
        xstream.useAttributeFor(ScanItem.class, "lastModified");
        xstream.useAttributeFor(ScanItem.class, "contentType");
        for (Field field : ScanItem.class.getDeclaredFields()) {
            if (!field.getName().startsWith("sha1")) continue;
            xstream.useAttributeFor(ScanItem.class, field.getName());
            if (!field.getType().isArray()) continue;
            xstream.registerLocalConverter(ScanItem.class, field.getName(), (SingleValueConverter)hashArrayConverter);
        }
        xstream.useAttributeFor(ScanItem.class, "sha512");
        xstream.useAttributeFor(ScanItem.class, "sha256");
        xstream.useAttributeFor(ScanItem.class, "nameSha1");
        xstream.useAttributeFor(ScanItem.class, "lastAccess");
        xstream.useAttributeFor(ScanItem.class, "kind");
        xstream.useAttributeFor(ScanItem.class, "id");
        xstream.useAttributeFor(ScanItem.class, "hasError");
        xstream.useAttributeFor(ScanItem.class, "dependency");
        xstream.useAttributeFor(ScanItem.class, "dailyDownloadCounts");
        xstream.useAttributeFor(ScanItem.class, "monthlyDownloadCounts");
        xstream.useAttributeFor(Repository.class, "manager");
        xstream.useAttributeFor(Repository.class, "id");
        xstream.useAttributeFor(Repository.class, "name");
        xstream.useAttributeFor(Repository.class, "format");
        xstream.useAttributeFor(Repository.class, "proxyUrl");
        xstream.useAttributeFor(ArtifactId.class, "kind");
        xstream.useAttributeFor(ArtifactId.class, "id");
        xstream.useAttributeFor(Dependency.class, "id");
        xstream.useAttributeFor(Dependency.class, "direct");
        xstream.useAttributeFor(ScanMetadata.class, "commitHash");
        xstream.registerConverter((Converter)new IgnoreDefaultsPropertiesConverter());
        return xstream;
    }
}

