/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.api;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredAction;
import com.softwarementors.extjs.djn.api.RegisteredPollMethod;
import com.softwarementors.extjs.djn.api.Registry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegisteredApi {
    @NonNull
    private Map<String, RegisteredAction> actions = new HashMap<String, RegisteredAction>();
    @NonNull
    private String fullApiFileName;
    @NonNull
    private String apiNamespace;
    @NonNull
    private String actionsNamespace;
    @NonNull
    private String name;
    @NonNull
    private Registry registry;
    @NonNull
    private String apiFile;

    RegisteredApi(Registry registry, String name, String apiFile, String fullApiFileName, String apiNamespace, String actionsNamespace) {
        assert (registry != null);
        assert (!StringUtils.isEmpty(name));
        assert (!StringUtils.isEmpty(apiNamespace));
        assert (!StringUtils.isEmpty(fullApiFileName));
        assert (actionsNamespace != null);
        this.registry = registry;
        this.apiFile = apiFile;
        this.fullApiFileName = fullApiFileName;
        this.apiNamespace = apiNamespace;
        this.actionsNamespace = actionsNamespace;
        this.name = name;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public RegisteredAction addAction(Class<?> actionClass, String name) {
        assert (actionClass != null);
        assert (!StringUtils.isEmpty(name));
        RegisteredAction result = new RegisteredAction(this, actionClass, name);
        this.actions.put(name, result);
        this.getRegistry().registerAction(result);
        if (Registry.logger.isDebugEnabled()) {
            Registry.logger.debug((Object)("Registered new Action. Name: '" + name + "', Java class: '" + actionClass.getName() + "'"));
        }
        return result;
    }

    public RegisteredAction getAction(String name) {
        assert (!StringUtils.isEmpty(name));
        return this.actions.get(name);
    }

    public List<RegisteredAction> getActions() {
        return new ArrayList<RegisteredAction>(this.actions.values());
    }

    public String getName() {
        return this.name;
    }

    public String getApiFile() {
        return this.apiFile;
    }

    public String getFullApiFileName() {
        return this.fullApiFileName;
    }

    public String getApiNamespace() {
        return this.apiNamespace;
    }

    public String getActionsNamespace() {
        return this.actionsNamespace;
    }

    public List<RegisteredPollMethod> getPollMethods() {
        ArrayList<RegisteredPollMethod> result = new ArrayList<RegisteredPollMethod>();
        for (RegisteredAction action : this.actions.values()) {
            result.addAll(action.getPollMethods());
        }
        return result;
    }
}

