/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.api;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredAction;
import com.softwarementors.extjs.djn.api.RegisteredMethodType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Method;

public abstract class RegisteredMethod {
    @NonNull
    private RegisteredAction action;
    @NonNull
    private Method method;
    @NonNull
    private String name;

    protected RegisteredMethod(RegisteredAction action, Method method, String name) {
        assert (action != null);
        assert (method != null);
        assert (!StringUtils.isEmpty(name));
        this.action = action;
        this.method = method;
        this.name = name;
    }

    public RegisteredAction getAction() {
        return this.action;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public int getParameterCount() {
        return this.getParameterTypes().length;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Class<?> getActionClass() {
        return this.action.getActionClass();
    }

    public String getName() {
        return this.name;
    }

    public String getActionName() {
        return this.getAction().getName();
    }

    public String getFullName() {
        return this.getActionName() + "." + this.getName();
    }

    public String getFullJavaMethodName() {
        return this.getAction().getFullJavaClassName() + "." + this.getMethod().getName();
    }

    public abstract RegisteredMethodType getType();
}

