/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.api;

import com.google.gson.JsonArray;
import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredAction;
import com.softwarementors.extjs.djn.api.RegisteredMethod;
import com.softwarementors.extjs.djn.api.RegisteredMethodType;
import com.softwarementors.extjs.djn.api.Registry;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

public class RegisteredStandardMethod
extends RegisteredMethod {
    private boolean formHandler;
    private boolean handleParametersAsJsonArray;

    RegisteredStandardMethod(RegisteredAction action, String name, Method method, boolean formHandler) {
        super(action, method, name);
        assert (!StringUtils.isEmpty(name));
        this.formHandler = formHandler;
        boolean bl = this.handleParametersAsJsonArray = !formHandler && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(JsonArray.class);
        assert (!this.formHandler || RegisteredStandardMethod.isValidFormHandlingMethod(method));
        assert (!action.hasStandardMethod(this.getName()));
        action.addStandardMethod(this);
    }

    public Type[] getGsonParameterTypes() {
        return Registry.getParameterTypes(this.getMethod());
    }

    public static boolean isValidFormHandlingMethod(Method method) {
        assert (method != null);
        return method.getParameterTypes().length == 2 && method.getParameterTypes()[0].equals(Map.class) || !method.getParameterTypes()[1].equals(Map.class);
    }

    public boolean isFormHandler() {
        return this.formHandler;
    }

    public int getClientParameterCount() {
        if (this.isFormHandler()) {
            return 1;
        }
        return this.getParameterCount();
    }

    public boolean getHandleParametersAsJsonArray() {
        return this.handleParametersAsJsonArray;
    }

    @Override
    public RegisteredMethodType getType() {
        return RegisteredMethodType.STANDARD;
    }
}

