/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.config;

import com.softwarementors.extjs.djn.DirectJNgineException;
import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.RegisteredAction;
import java.lang.reflect.Method;

public class ApiConfigurationException
extends DirectJNgineException {
    private static final long serialVersionUID = -3426947847986039782L;

    private ApiConfigurationException(String message) {
        super(message);
        assert (!StringUtils.isEmpty(message));
    }

    public static ApiConfigurationException forActionAlreadyRegistered(String newActionName, Class<?> newActionClass, Class<?> registeredActionClass) {
        assert (!StringUtils.isEmpty(newActionName));
        assert (newActionClass != null);
        assert (registeredActionClass != null);
        return new ApiConfigurationException("Action '" + newActionName + "' is already registered for class '" + registeredActionClass.getName() + "', but you are attempting to register it for class '" + newActionClass.getName() + "'. It is not possible to register two classes with the same action name.");
    }

    public static ApiConfigurationException forMethodAlreadyRegisteredInAction(String registeredMethodName, String actionName) {
        assert (!StringUtils.isEmpty(registeredMethodName));
        assert (!StringUtils.isEmpty(actionName));
        return new ApiConfigurationException("Method '" + registeredMethodName + "' is already registered for action '" + actionName + "'");
    }

    public static ApiConfigurationException forMethodHasWrongParametersForAFormHandler(String actionName, String methodName) {
        assert (!StringUtils.isEmpty(actionName));
        assert (!StringUtils.isEmpty(methodName));
        return new ApiConfigurationException("Method '" + methodName + "' in action '" + actionName + "' can't be registered as a form handler because the corresponding Java method does not have the right parameter types, '(Map<String,String>, Map<String,FileItem>)'");
    }

    public static ApiConfigurationException forMethodCantBeStandardAndFormPostMethodAtTheSameTime(RegisteredAction action, Method method) {
        assert (action != null);
        assert (method != null);
        return new ApiConfigurationException("Method '" + method.getName() + "' in class '" + action.getActionClass().getName() + "' is a standard and a form post method at the same time: please, check your annotations and method naming to remove the ambiguity.");
    }

    public static ApiConfigurationException forPollMethodCantBeStandardOrFormPostMethodAtTheSameTime(RegisteredAction action, Method method) {
        assert (action != null);
        assert (method != null);
        return new ApiConfigurationException("Method '" + method.getName() + "' in class '" + action.getActionClass().getName() + "' can't be a poll method and a standard/form post method at the same time: please, check your annotations and method naming to remove the ambiguity.");
    }

    public static ApiConfigurationException forMethodHasWrongParametersForAPollHandler(Method method) {
        assert (method != null);
        return new ApiConfigurationException("Method '" + method.getName() + "' in class '" + method.getDeclaringClass().getName() + "' can't be registered as a poll handler because the corresponding Java method does not have the right parameter types, '(Map<String,String>)'");
    }

    public static ApiConfigurationException forPollEventAlreadyRegistered(String eventName) {
        assert (!StringUtils.isEmpty(eventName));
        return new ApiConfigurationException("Poll event '" + eventName + "' already registered . It is not possible to register the same event twice");
    }

    public static ApiConfigurationException forApiAlreadyRegistered(String name) {
        assert (!StringUtils.isEmpty(name));
        return new ApiConfigurationException("Api '" + name + "' already registered. It is not possible to register the same api twice");
    }
}

