/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.router.processor.standard.form;

import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.processor.RequestException;
import com.softwarementors.extjs.djn.router.processor.ResponseData;
import com.softwarementors.extjs.djn.router.processor.standard.StandardErrorResponseData;
import com.softwarementors.extjs.djn.router.processor.standard.StandardRequestProcessorBase;
import com.softwarementors.extjs.djn.router.processor.standard.StandardSuccessResponseData;
import com.softwarementors.extjs.djn.router.processor.standard.form.FormPostRequestData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

public abstract class FormPostRequestProcessorBase
extends StandardRequestProcessorBase {
    @NonNull
    private static Logger logger = Logger.getLogger(FormPostRequestProcessorBase.class);

    protected FormPostRequestProcessorBase(Registry registry, Dispatcher dispatcher, GlobalConfiguration globalConfiguration) {
        super(registry, dispatcher, globalConfiguration);
    }

    protected String process(Map<String, String> formParameters, Map<String, FileItem> fileFields) {
        assert (formParameters != null);
        assert (fileFields != null);
        FormPostRequestProcessorBase.checkNoMissingParameters(formParameters);
        FormPostRequestData request = FormPostRequestProcessorBase.createRequestObject(formParameters, fileFields);
        ResponseData response = this.processRequest(request);
        StringBuilder result = new StringBuilder();
        this.appendIndividualResponseJsonString(response, result);
        return result.toString();
    }

    private static String getAndRemove(Map<String, String> keyValues, String key) {
        String result = keyValues.get(key);
        keyValues.remove(key);
        return result;
    }

    private static FormPostRequestData createRequestObject(Map<String, String> formParameters, Map<String, FileItem> fileFields) {
        assert (formParameters != null);
        assert (fileFields != null);
        HashMap<String, String> parameters = new HashMap<String, String>(formParameters);
        String type = FormPostRequestProcessorBase.getAndRemove(parameters, "extType");
        String action = FormPostRequestProcessorBase.getAndRemove(parameters, "extAction");
        String method = FormPostRequestProcessorBase.getAndRemove(parameters, "extMethod");
        Long tid = Long.parseLong(FormPostRequestProcessorBase.getAndRemove(parameters, "extTID"));
        boolean isUpload = Boolean.parseBoolean(FormPostRequestProcessorBase.getAndRemove(parameters, "extUpload"));
        return new FormPostRequestData(type, action, method, tid, isUpload, parameters, fileFields);
    }

    private static void checkNoMissingParameters(Map<String, String> parameters) {
        assert (parameters != null);
        ArrayList<String> missingParameters = new ArrayList<String>();
        FormPostRequestProcessorBase.addParameterIfMissing(parameters, "extAction", missingParameters);
        FormPostRequestProcessorBase.addParameterIfMissing(parameters, "extMethod", missingParameters);
        FormPostRequestProcessorBase.addParameterIfMissing(parameters, "extType", missingParameters);
        FormPostRequestProcessorBase.addParameterIfMissing(parameters, "extTID", missingParameters);
        FormPostRequestProcessorBase.addParameterIfMissing(parameters, "extUpload", missingParameters);
        if (!missingParameters.isEmpty()) {
            RequestException ex = RequestException.forFormPostMissingParameters(missingParameters);
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private static void addParameterIfMissing(Map<String, String> parameters, String parameterName, List<String> missingParameters) {
        assert (parameters != null);
        assert (!StringUtils.isEmpty(parameterName));
        assert (missingParameters != null);
        if (!parameters.containsKey(parameterName)) {
            missingParameters.add(parameterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseData processRequest(FormPostRequestData request) {
        assert (request != null);
        try {
            Object[] parameters = new Object[]{request.getFormParameters(), request.getFileFields()};
            Object result = this.dispatchStandardMethod(request.getAction(), request.getMethod(), parameters);
            StandardSuccessResponseData response = new StandardSuccessResponseData(request.getTid(), request.getAction(), request.getMethod());
            response.setResult(result);
            StandardSuccessResponseData standardSuccessResponseData = response;
            return standardSuccessResponseData;
        }
        catch (Exception t) {
            StandardErrorResponseData response = this.createJsonServerErrorResponse(request, t);
            logger.error((Object)("(Controlled) server error: " + t.getMessage() + " for Form Post Method " + request.getFullMethodName()), (Throwable)t);
            StandardErrorResponseData standardErrorResponseData = response;
            return standardErrorResponseData;
        }
        finally {
            for (FileItem fileItem : request.getFileFields().values()) {
                fileItem.delete();
            }
        }
    }
}

