/*
 * Decompiled with CFR 0.152.
 */
package com.softwarementors.extjs.djn.router.processor.standard.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.softwarementors.extjs.djn.ClassUtils;
import com.softwarementors.extjs.djn.ParallelTask;
import com.softwarementors.extjs.djn.StringUtils;
import com.softwarementors.extjs.djn.Timer;
import com.softwarementors.extjs.djn.UnexpectedException;
import com.softwarementors.extjs.djn.api.RegisteredStandardMethod;
import com.softwarementors.extjs.djn.api.Registry;
import com.softwarementors.extjs.djn.config.GlobalConfiguration;
import com.softwarementors.extjs.djn.gson.JsonDeserializationManager;
import com.softwarementors.extjs.djn.gson.JsonException;
import com.softwarementors.extjs.djn.router.dispatcher.Dispatcher;
import com.softwarementors.extjs.djn.router.processor.RequestException;
import com.softwarementors.extjs.djn.router.processor.standard.StandardErrorResponseData;
import com.softwarementors.extjs.djn.router.processor.standard.StandardRequestProcessorBase;
import com.softwarementors.extjs.djn.router.processor.standard.StandardSuccessResponseData;
import com.softwarementors.extjs.djn.router.processor.standard.json.JsonRequestData;
import com.softwarementors.extjs.djn.router.processor.standard.json.JsonRequestProcessorThread;
import com.softwarementors.extjs.djn.router.processor.standard.json.JsonRequestProcessorThreadConfigurationException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class JsonRequestProcessor
extends StandardRequestProcessorBase {
    private static final boolean SUPPORTS_OBJECT_TYPE_PARAMETER = false;
    @NonNull
    private static final Logger logger = Logger.getLogger(JsonRequestProcessor.class);
    @CheckForNull
    private static volatile ExecutorService individualRequestsThreadPool;
    @NonNull
    private JsonParser parser = new JsonParser();

    protected JsonParser getJsonParser() {
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="This method will never return null, because if the value it should return is null on entry, it assigns it first")
    private ExecutorService getIndividualRequestsThreadPool() {
        Class<JsonRequestProcessor> clazz = JsonRequestProcessor.class;
        synchronized (JsonRequestProcessor.class) {
            if (individualRequestsThreadPool == null) {
                individualRequestsThreadPool = this.createThreadPool();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return individualRequestsThreadPool;
        }
    }

    private ExecutorService createThreadPool() {
        assert (this.getGlobalConfiguration() != null);
        ThreadPoolExecutor result = new ThreadPoolExecutor(this.getGlobalConfiguration().getBatchRequestsMinThreadsPoolSize(), this.getGlobalConfiguration().getBatchRequestsMaxThreadsPoolSize(), this.getGlobalConfiguration().getBatchRequestsThreadKeepAliveSeconds(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        return result;
    }

    public JsonRequestProcessor(Registry registry, Dispatcher dispatcher, GlobalConfiguration globalConfiguration) {
        super(registry, dispatcher, globalConfiguration);
    }

    public String process(Reader reader, Writer writer) throws IOException {
        JsonRequestData[] requests;
        boolean isBatched;
        String requestString = IOUtils.toString((Reader)reader);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request data (JSON)=>" + requestString));
        }
        boolean bl = isBatched = (requests = this.getIndividualJsonRequests(requestString)).length > 1;
        if (isBatched && logger.isDebugEnabled()) {
            logger.debug((Object)("Batched request: " + requests.length + " individual requests batched"));
        }
        Collection<String> responses = null;
        boolean useMultipleThreadsIfBatched = isBatched && this.getGlobalConfiguration().getBatchRequestsMultithreadingEnabled();
        responses = useMultipleThreadsIfBatched ? this.processIndividualRequestsInMultipleThreads(requests) : this.processIndividualRequestsInThisThread(requests);
        String result = JsonRequestProcessor.convertInvididualResponsesToJsonString(responses);
        writer.write(result);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ResponseData data (JSON)=>" + result));
        }
        return result;
    }

    private Collection<String> processIndividualRequestsInThisThread(JsonRequestData[] requests) {
        boolean isBatched = requests.length > 1;
        ArrayList<String> responses = new ArrayList<String>(requests.length);
        int requestNumber = 1;
        for (JsonRequestData request : requests) {
            String response = this.processIndividualRequest(request, isBatched, requestNumber);
            responses.add(response);
            ++requestNumber;
        }
        return responses;
    }

    private Collection<String> processIndividualRequestsInMultipleThreads(JsonRequestData[] requests) {
        assert (requests != null);
        int individualRequestNumber = 1;
        ArrayList tasks = new ArrayList(requests.length);
        for (JsonRequestData request : requests) {
            JsonRequestProcessorThread thread = this.createJsonRequestProcessorThread();
            thread.initialize(this, request, individualRequestNumber);
            tasks.add(thread);
            ++individualRequestNumber;
        }
        try {
            ParallelTask task = new ParallelTask(this.getIndividualRequestsThreadPool(), tasks, this.getGlobalConfiguration().getBatchRequestsMaxThreadsPerRequest());
            Object responses = task.get();
            return responses;
        }
        catch (InterruptedException e) {
            ArrayList<String> responses = new ArrayList<String>(requests.length);
            logger.error((Object)("(Controlled) server error cancelled a batch of " + requests.length + " individual requests due to an InterruptedException exception. " + e.getMessage()), (Throwable)e);
            for (JsonRequestData request : requests) {
                StandardErrorResponseData response = this.createJsonServerErrorResponse(request, e);
                responses.add(this.getGson().toJson((Object)response));
            }
            return responses;
        }
        catch (ExecutionException e) {
            UnexpectedException ex = UnexpectedException.forExecutionExceptionShouldNotHappenBecauseProcessorHandlesExceptionsAsServerErrorResponses(e);
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private JsonRequestProcessorThread createJsonRequestProcessorThread() {
        Class<? extends JsonRequestProcessorThread> cls = this.getGlobalConfiguration().getJsonRequestProcessorThreadClass();
        try {
            return cls.newInstance();
        }
        catch (InstantiationException e) {
            JsonRequestProcessorThreadConfigurationException ex = JsonRequestProcessorThreadConfigurationException.forUnableToInstantiateJsonRequestProcessorThread(cls, e);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (IllegalAccessException e) {
            JsonRequestProcessorThreadConfigurationException ex = JsonRequestProcessorThreadConfigurationException.forUnableToInstantiateJsonRequestProcessorThread(cls, e);
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private JsonRequestData[] getIndividualJsonRequests(String requestString) {
        assert (!StringUtils.isEmpty(requestString));
        JsonObject[] individualJsonRequests = JsonRequestProcessor.parseIndividualJsonRequests(requestString, this.getJsonParser());
        JsonRequestData[] individualRequests = new JsonRequestData[individualJsonRequests.length];
        int i = 0;
        for (JsonObject individualRequest : individualJsonRequests) {
            individualRequests[i] = JsonRequestProcessor.createIndividualJsonRequest(individualRequest);
            ++i;
        }
        return individualRequests;
    }

    private static String convertInvididualResponsesToJsonString(Collection<String> responses) {
        assert (responses != null);
        assert (!responses.isEmpty());
        StringBuilder result = new StringBuilder();
        if (responses.size() > 1) {
            result.append("[\n");
        }
        int j = 0;
        for (String response : responses) {
            boolean isLast;
            result.append(response);
            boolean bl = isLast = j == responses.size() - 1;
            if (!isLast) {
                result.append(",");
            }
            ++j;
        }
        if (responses.size() > 1) {
            result.append("]");
        }
        return result.toString();
    }

    private Object[] getIndividualRequestParameters(JsonRequestData request) {
        Object[] parameters;
        assert (request != null);
        RegisteredStandardMethod method = this.getStandardMethod(request.getAction(), request.getMethod());
        assert (method != null);
        if (!method.getHandleParametersAsJsonArray()) {
            JsonRequestProcessor.checkJsonMethodParameterTypes(request.getJsonData(), method);
            parameters = this.jsonDataToMethodParameters(method, request.getJsonData(), method.getParameterTypes(), method.getGsonParameterTypes());
        } else {
            parameters = new Object[]{request.getJsonData()};
        }
        return parameters;
    }

    private Object[] jsonDataToMethodParameters(RegisteredStandardMethod method, JsonArray jsonParametersArray, Class<?>[] parameterTypes, Type[] gsonParameterTypes) {
        assert (method != null);
        assert (parameterTypes != null);
        try {
            JsonElement[] jsonParameters = JsonRequestProcessor.getJsonElements(jsonParametersArray);
            Object[] result = this.getMethodParameters(method, jsonParameters);
            return result;
        }
        catch (JsonParseException ex) {
            throw JsonException.forFailedConversionFromJsonStringToMethodParameters(method, jsonParametersArray.toString(), parameterTypes, gsonParameterTypes, ex);
        }
    }

    private static JsonElement[] getJsonElements(JsonArray jsonParameters) {
        if (jsonParameters == null) {
            return new JsonElement[0];
        }
        JsonArray dataArray = jsonParameters;
        JsonElement[] parameters = new JsonElement[dataArray.size()];
        for (int i = 0; i < dataArray.size(); ++i) {
            parameters[i] = dataArray.get(i);
        }
        return parameters;
    }

    private static boolean isString(JsonElement element) {
        assert (element != null);
        return element.isJsonPrimitive() && ((JsonPrimitive)element).isString();
    }

    private Object[] getMethodParameters(RegisteredStandardMethod method, JsonElement[] jsonParameters) {
        assert (method != null);
        assert (jsonParameters != null);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] result = new Object[jsonParameters.length];
        for (int i = 0; i < jsonParameters.length; ++i) {
            JsonElement jsonValue = jsonParameters[i];
            Class<?> parameterType = parameterTypes[i];
            Object value = null;
            Type gsonType = null;
            if (method.getGsonParameterTypes() != null) {
                gsonType = method.getGsonParameterTypes()[i];
            }
            result[i] = value = this.jsonToJavaObject(jsonValue, parameterType, gsonType);
        }
        return result;
    }

    @CheckForNull
    private Object jsonToJavaObject(JsonElement jsonValue, Class<?> parameterType, Type gsonType) {
        if (jsonValue.isJsonNull()) {
            return null;
        }
        if (JsonRequestProcessor.isString(jsonValue)) {
            if (parameterType.equals(String.class)) {
                String value = jsonValue.getAsString();
                return value;
            }
            if (parameterType.equals(Character.TYPE) || parameterType.equals(Character.class)) {
                Character value = Character.valueOf(jsonValue.getAsString().charAt(0));
                return value;
            }
        }
        if (parameterType.equals(Object.class)) {
            // empty if block
        }
        boolean useCustomGsonType = gsonType != null;
        boolean fakeJsonArrayForManyValuedClasses = JsonDeserializationManager.isManyValuedClass(parameterType) && !jsonValue.isJsonArray();
        Type typeToInstantiate = parameterType;
        if (useCustomGsonType) {
            typeToInstantiate = gsonType;
        }
        JsonElement json = jsonValue;
        if (fakeJsonArrayForManyValuedClasses) {
            JsonArray fakeJson = new JsonArray();
            fakeJson.add(jsonValue);
            json = fakeJson;
        }
        Object value = this.getGson().fromJson(json, typeToInstantiate);
        return value;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckForNull
    private Object toSimpleJavaType(JsonElement jsonValue) {
        void var2_9;
        Object var2_2 = null;
        if (jsonValue.isJsonNull()) return var2_9;
        if (jsonValue.isJsonPrimitive()) {
            JsonPrimitive primitive = jsonValue.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                Boolean bl = primitive.getAsBoolean();
                return var2_9;
            } else if (primitive.isNumber()) {
                Double d = primitive.getAsDouble();
                return var2_9;
            } else {
                if (!primitive.isString()) throw UnexpectedException.forUnexpectedCodeBranchExecuted();
                String string = primitive.getAsString();
            }
            return var2_9;
        } else if (jsonValue.isJsonArray()) {
            JsonArray array = jsonValue.getAsJsonArray();
            Object[] result = new Object[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                result[i] = this.toSimpleJavaType(array.get(i));
            }
            Object[] objectArray = result;
            return var2_9;
        } else {
            if (!jsonValue.isJsonObject()) throw UnexpectedException.forUnexpectedCodeBranchExecuted();
            JsonObject obj = jsonValue.getAsJsonObject();
            Iterator properties = obj.entrySet().iterator();
            HashMap result = new HashMap();
            while (properties.hasNext()) {
                Map.Entry property = (Map.Entry)properties.next();
                JsonElement propertyValue = (JsonElement)property.getValue();
                result.put(property.getKey(), this.toSimpleJavaType(propertyValue));
            }
            HashMap hashMap = result;
        }
        return var2_9;
    }

    private static JsonElement[] getIndividualRequestJsonParameters(JsonArray jsonParameters) {
        if (jsonParameters == null) {
            return new JsonElement[0];
        }
        JsonElement[] parameters = new JsonElement[jsonParameters.size()];
        for (int i = 0; i < jsonParameters.size(); ++i) {
            parameters[i] = jsonParameters.get(i);
        }
        return parameters;
    }

    private static void checkJsonMethodParameterTypes(JsonArray jsonData, RegisteredStandardMethod method) {
        assert (method != null);
        JsonElement[] jsonParameters = JsonRequestProcessor.getIndividualRequestJsonParameters(jsonData);
        Class<?>[] parameterTypes = method.getParameterTypes();
        assert (jsonParameters.length == parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            JsonElement jsonElement = jsonParameters[i];
            Class<?> parameterType = parameterTypes[i];
            if (JsonRequestProcessor.isValidJsonTypeForJavaType(jsonElement, parameterType)) continue;
            throw new IllegalArgumentException("'" + jsonElement.toString() + "' is not a valid json text for the '" + parameterType.getName() + "' Java type");
        }
    }

    private static boolean isValidJsonTypeForJavaType(JsonElement jsonElement, Class<?> parameterType) {
        assert (jsonElement != null);
        assert (parameterType != null);
        if (jsonElement.isJsonNull()) {
            return !parameterType.isPrimitive();
        }
        if (parameterType.isArray()) {
            return true;
        }
        if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
            return jsonElement.isJsonPrimitive() && ((JsonPrimitive)jsonElement).isBoolean();
        }
        if (parameterType.equals(Character.TYPE) || parameterType.equals(Character.class)) {
            if (jsonElement.isJsonPrimitive() && ((JsonPrimitive)jsonElement).isString()) {
                return jsonElement.getAsString().length() == 1;
            }
            return false;
        }
        if (parameterType.equals(String.class)) {
            return jsonElement.isJsonPrimitive() && ((JsonPrimitive)jsonElement).isString();
        }
        if (ClassUtils.isNumericType(parameterType)) {
            return jsonElement.isJsonPrimitive() && ((JsonPrimitive)jsonElement).isNumber();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String processIndividualRequest(JsonRequestData request, boolean isBatched, int requestNumber) {
        assert (request != null);
        boolean resultReported = false;
        Timer timer = new Timer();
        try {
            if (isBatched && logger.isDebugEnabled()) {
                logger.debug((Object)("  - Individual request #" + requestNumber + " request data=>" + this.getGson().toJson((Object)request)));
            }
            Object[] parameters = this.getIndividualRequestParameters(request);
            String action = request.getAction();
            String method = request.getMethod();
            StandardSuccessResponseData response = new StandardSuccessResponseData(request.getTid(), action, method);
            JsonDeserializationManager mgr = JsonDeserializationManager.getManager();
            try {
                Object result = this.dispatchStandardMethod(action, method, parameters);
                mgr.friendOnlyAccess_setRoot(result);
                response.setResult(result);
                String json = this.getGson().toJson((Object)response);
                if (isBatched && logger.isDebugEnabled()) {
                    timer.stop();
                    timer.logDebugTimeInMilliseconds("  - Individual request #" + requestNumber + " response data=>" + json);
                    resultReported = true;
                }
                String string = json;
                mgr.friendOnlyAccess_dispose();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    mgr.friendOnlyAccess_dispose();
                    throw throwable;
                }
                catch (Exception t) {
                    StandardErrorResponseData response2 = this.createJsonServerErrorResponse(request, t);
                    String json = this.getGson().toJson((Object)response2);
                    logger.error((Object)("(Controlled) server error: " + t.getMessage() + " for Method '" + request.getFullMethodName() + "'"), (Throwable)t);
                    String string = json;
                    return string;
                }
            }
        }
        finally {
            if (!resultReported) {
                timer.stop();
                if (isBatched && logger.isDebugEnabled()) {
                    timer.logDebugTimeInMilliseconds("  - Individual request #" + requestNumber + ": " + request.getFullMethodName() + ". Time");
                }
            }
        }
    }

    private static JsonObject[] parseIndividualJsonRequests(String requestString, JsonParser parser) {
        JsonObject[] individualRequests;
        assert (!StringUtils.isEmpty(requestString));
        assert (parser != null);
        JsonElement root = parser.parse(requestString);
        if (root.isJsonArray()) {
            JsonArray rootArray = (JsonArray)root;
            if (rootArray.size() == 0) {
                RequestException ex = RequestException.forRequestBatchMustHaveAtLeastOneRequest();
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            individualRequests = new JsonObject[rootArray.size()];
            int i = 0;
            for (JsonElement item : rootArray) {
                if (!item.isJsonObject()) {
                    RequestException ex = RequestException.forRequestBatchItemMustBeAValidJsonObject(i);
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
                individualRequests[i] = (JsonObject)item;
                ++i;
            }
        } else if (root.isJsonObject()) {
            individualRequests = new JsonObject[]{(JsonObject)root};
        } else {
            RequestException ex = RequestException.forRequestMustBeAValidJsonObjectOrArray();
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return individualRequests;
    }

    private static JsonRequestData createIndividualJsonRequest(JsonObject element) {
        assert (element != null);
        String action = JsonRequestProcessor.getNonEmptyJsonString(element, "action");
        String method = JsonRequestProcessor.getNonEmptyJsonString(element, "method");
        Long tid = JsonRequestProcessor.getNonEmptyJsonLong(element, "tid");
        String type = JsonRequestProcessor.getNonEmptyJsonString(element, "type");
        JsonArray jsonData = JsonRequestProcessor.getMethodParametersJsonData(element);
        JsonRequestData result = new JsonRequestData(type, action, method, tid, jsonData);
        return result;
    }

    @CheckForNull
    private static JsonArray getMethodParametersJsonData(JsonObject object) {
        assert (object != null);
        JsonElement data = object.get("data");
        if (data == null) {
            RequestException ex = RequestException.forJsonElementMissing("data");
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        if (data.isJsonNull()) {
            return null;
        }
        if (!data.isJsonNull() && !data.isJsonArray()) {
            RequestException ex = RequestException.forJsonElementMustBeAJsonArray("data", data.toString());
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return (JsonArray)data;
    }

    private static <T> T getNonEmptyJsonPrimitiveValue(JsonObject object, String elementName, PrimitiveJsonValueGetter<T> getter) {
        assert (object != null);
        assert (!StringUtils.isEmpty(elementName));
        try {
            JsonElement element = object.get(elementName);
            if (element == null) {
                RequestException ex = RequestException.forJsonElementMissing(elementName);
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            T result = null;
            if (element.isJsonPrimitive()) {
                result = getter.checkedGet((JsonPrimitive)element);
            }
            if (result == null) {
                RequestException ex = RequestException.forJsonElementMustBeANonNullOrEmptyValue(elementName, getter.getValueType());
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            return result;
        }
        catch (JsonParseException e) {
            String message = "Probably a DirectJNgine BUG: there should not be JSON parse exceptions: we should have checked ALL error conditions. " + e.getMessage();
            logger.error((Object)message, (Throwable)e);
            assert (false) : message;
            throw e;
        }
    }

    private static Long getNonEmptyJsonLong(JsonObject object, String elementName) {
        assert (object != null);
        assert (!StringUtils.isEmpty(elementName));
        return JsonRequestProcessor.getNonEmptyJsonPrimitiveValue(object, elementName, new PrimitiveJsonLongGetter());
    }

    private static String getNonEmptyJsonString(JsonObject object, String elementName) {
        assert (object != null);
        assert (!StringUtils.isEmpty(elementName));
        return JsonRequestProcessor.getNonEmptyJsonPrimitiveValue(object, elementName, new PrimitiveJsonStringGetter());
    }

    private static class PrimitiveJsonStringGetter
    implements PrimitiveJsonValueGetter<String> {
        private PrimitiveJsonStringGetter() {
        }

        @Override
        public String checkedGet(JsonPrimitive value) {
            assert (value != null);
            if (value.isString()) {
                String result = value.getAsString();
                if (result.equals("")) {
                    result = null;
                }
                return result;
            }
            return null;
        }

        @Override
        public Class<String> getValueType() {
            return String.class;
        }
    }

    private static class PrimitiveJsonLongGetter
    implements PrimitiveJsonValueGetter<Long> {
        private PrimitiveJsonLongGetter() {
        }

        @Override
        public Long checkedGet(JsonPrimitive value) {
            assert (value != null);
            if (value.isNumber()) {
                String v = value.toString();
                try {
                    return Long.parseLong(v);
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public Class<Long> getValueType() {
            return Long.class;
        }
    }

    static interface PrimitiveJsonValueGetter<T> {
        @CheckForNull
        public T checkedGet(JsonPrimitive var1);

        public Class<T> getValueType();
    }
}

