/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHelper {
    private static final Logger log = LoggerFactory.getLogger(ShutdownHelper.class);
    public static final ShutdownDelegate JAVA = new JavaShutdownDelegate();
    public static final ShutdownDelegate NOOP = new NoopShutdownDelegate();
    private static ShutdownDelegate delegate = JAVA;

    private ShutdownHelper() {
    }

    public static ShutdownDelegate getDelegate() {
        if (delegate == null) {
            throw new IllegalStateException();
        }
        return delegate;
    }

    public static void setDelegate(ShutdownDelegate delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        ShutdownHelper.delegate = delegate;
    }

    public static void exit(int code) {
        ShutdownHelper.getDelegate().doExit(code);
    }

    public static void halt(int code) {
        ShutdownHelper.getDelegate().doHalt(code);
    }

    public static class JavaShutdownDelegate
    implements ShutdownDelegate {
        @Override
        public void doExit(int code) {
            System.exit(code);
        }

        @Override
        public void doHalt(int code) {
            Runtime.getRuntime().halt(code);
        }
    }

    public static class NoopShutdownDelegate
    implements ShutdownDelegate {
        @Override
        public void doExit(int code) {
            log.warn("Ignoring exit({}) request", (Object)code);
        }

        @Override
        public void doHalt(int code) {
            log.warn("Ignoring halt({}) request", (Object)code);
        }
    }

    public static interface ShutdownDelegate {
        public void doExit(int var1);

        public void doHalt(int var1);
    }
}

