/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.jetty;

import com.google.common.base.Preconditions;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.sonatype.nexus.bootstrap.jetty.DockerSubdomainRepositoryMapping;

public class DockerSubdomainRequestCustomizer
implements HttpConfiguration.Customizer {
    private final String nexusContextPath;
    private final int jettyPort;
    private final int jettySslPort;

    public DockerSubdomainRequestCustomizer(String contextPath, int jettyPort, int jettySslPort) {
        this.nexusContextPath = String.valueOf((String)Preconditions.checkNotNull((Object)contextPath)) + (contextPath.endsWith("/") ? "" : "/");
        this.jettyPort = jettyPort;
        this.jettySslPort = jettySslPort;
    }

    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        HttpURI uri = request.getHttpURI();
        String version = null;
        if (uri.getPath().startsWith("/v1")) {
            version = "/v1";
        } else if (uri.getPath().startsWith("/v2")) {
            version = "/v2";
        }
        if (version != null) {
            int localPort;
            if (connector instanceof ServerConnector && (localPort = ((ServerConnector)connector).getLocalPort()) != this.jettyPort && localPort != this.jettySslPort) {
                return;
            }
            String repositoryName = DockerSubdomainRepositoryMapping.get(request.getHeader("Host"));
            if (repositoryName != null) {
                request.setHttpURI(new HttpURI(uri.toString().replaceFirst(version, String.valueOf(this.nexusContextPath) + "repository/" + repositoryName + version)));
                request.setMetaData(request.getMetaData());
            }
        }
    }
}

