/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Hashtable;
import java.util.stream.Collectors;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.slf4j.MDC;
import org.sonatype.nexus.bootstrap.Launcher;
import org.sonatype.nexus.bootstrap.internal.ShutdownHelper;
import org.sonatype.nexus.bootstrap.jetty.JettyServerConfiguration;
import org.sonatype.nexus.bootstrap.osgi.ConnectorConfigurationTracker;

public class LauncherActivator
implements BundleActivator,
ShutdownHelper.ShutdownDelegate {
    private Framework framework;
    private Launcher launcher;
    private ConnectorConfigurationTracker connectorConfigurationTracker;
    private ServiceRegistration<JettyServerConfiguration> jettyServerConfigurationRegistration;

    public void start(BundleContext bundleContext) throws Exception {
        this.framework = (Framework)bundleContext.getBundle(0L);
        ShutdownHelper.setDelegate(this);
        String baseDir = LauncherActivator.checkProperty(bundleContext, "karaf.base");
        String dataDir = LauncherActivator.checkProperty(bundleContext, "karaf.data");
        File defaultsFile = new File(baseDir, "etc/nexus-default.properties");
        File propertiesFile = new File(dataDir, "etc/nexus.properties");
        File nodeNamePropertiesFile = new File(dataDir, "etc/node-name.properties");
        LauncherActivator.maybeCopyDefaults(defaultsFile, propertiesFile);
        MDC.put((String)"userId", (String)"*SYSTEM");
        this.launcher = new Launcher(defaultsFile, propertiesFile, nodeNamePropertiesFile);
        this.launcher.startAsync(() -> {
            this.connectorConfigurationTracker = new ConnectorConfigurationTracker(bundleContext, this.launcher.getServer());
            this.connectorConfigurationTracker.open();
        });
        Hashtable<String, String> properties = new Hashtable<String, String>(Collections.singletonMap("name", "nexus"));
        this.jettyServerConfigurationRegistration = bundleContext.registerService(JettyServerConfiguration.class, (Object)new JettyServerConfiguration(this.launcher.getServer().defaultConnectors()), properties);
    }

    private static void maybeCopyDefaults(File defaultsFile, File propertiesFile) throws Exception {
        if (defaultsFile.exists() && !propertiesFile.exists()) {
            File parentDir = propertiesFile.getParentFile();
            if (parentDir != null && !parentDir.isDirectory()) {
                Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
            }
            Files.write(propertiesFile.toPath(), (Iterable<? extends CharSequence>)Files.readAllLines(defaultsFile.toPath(), StandardCharsets.ISO_8859_1).stream().filter(l -> !l.startsWith("##")).map(l -> l.startsWith("#") || l.isEmpty() ? l : "# " + l).collect(Collectors.toList()), StandardCharsets.ISO_8859_1, new OpenOption[0]);
        }
    }

    private static String checkProperty(BundleContext bundleContext, String name) {
        String value = bundleContext.getProperty(name);
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing property " + name);
        }
        return value;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.connectorConfigurationTracker != null) {
                this.connectorConfigurationTracker.close();
            }
            if (this.jettyServerConfigurationRegistration != null) {
                this.jettyServerConfigurationRegistration.unregister();
            }
            if (this.launcher != null) {
                this.launcher.stop();
            }
        }
        finally {
            this.connectorConfigurationTracker = null;
            this.jettyServerConfigurationRegistration = null;
            this.launcher = null;
        }
    }

    @Override
    public void doExit(int code) {
        ShutdownHelper.setDelegate(ShutdownHelper.JAVA);
        try {
            try {
                this.framework.stop();
                this.framework.waitForStop(0L);
            }
            catch (InterruptedException interruptedException) {
                ShutdownHelper.exit(code);
            }
            catch (Throwable e) {
                e.printStackTrace();
                ShutdownHelper.exit(code);
            }
        }
        finally {
            ShutdownHelper.exit(code);
        }
    }

    @Override
    public void doHalt(int code) {
        ShutdownHelper.halt(code);
    }
}

