/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.jacksonstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PropertyComparator
implements Comparator<String> {
    static final List<String> DOCUMENT_PROPERTY_ORDER = Arrays.asList("documentNamespace", "spdxVersion", "creationInfo", "name", "dataLicense", "comment", "externalDocumentRef", "documentDescribes", "packages", "files", "snippets", "hasExtractedLicensingInfo", "annotation", "relationships");
    static final Map<String, List<String>> propertyOrderMap;
    private List<String> propertyOrder;

    static {
        HashMap<String, List<String>> hm = new HashMap<String, List<String>>();
        hm.put("SpdxDocument", DOCUMENT_PROPERTY_ORDER);
        propertyOrderMap = Collections.unmodifiableMap(hm);
    }

    public PropertyComparator(String type) {
        this.propertyOrder = propertyOrderMap.get(type);
        if (Objects.isNull(this.propertyOrder)) {
            this.propertyOrder = new ArrayList<String>();
        }
    }

    @Override
    public int compare(String o1, String o2) {
        int retval;
        int i2;
        int i1 = this.propertyOrder.indexOf(o1);
        if (i1 < 0) {
            i1 = 999;
        }
        if ((i2 = this.propertyOrder.indexOf(o2)) < 0) {
            i2 = 999;
        }
        if ((retval = Integer.compare(i1, i2)) == 0) {
            retval = o1.compareTo(o2);
        }
        return retval;
    }
}

