/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonatype.goodies.packageurl.EmptySegmentException;
import org.sonatype.goodies.packageurl.IllegalSegmentContentException;
import org.sonatype.goodies.packageurl.InvalidException;
import org.sonatype.goodies.packageurl.MoreStrings;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.goodies.packageurl.PackageUrlBuilder;
import org.sonatype.goodies.packageurl.PercentEncoding;

class PackageUrlParser {
    static final String TYPE = "[a-zA-Z][a-zA-Z\\d.+-]*";
    static final String NAMESPACE = "[^@#?]+";
    static final String NAMESPACE_SEGMENT = "[^/]+";
    static final String NAME = "[^/@#?]+";
    static final String VERSION = ".+?";
    static final String QUALIFIER_KEY = "[a-zA-Z.\\-_][a-zA-Z\\d.\\-_]*";
    static final String QUALIFIER_VALUE = "[^&]+?";
    static final String QUALIFIER = String.format("%s=%s", "[a-zA-Z.\\-_][a-zA-Z\\d.\\-_]*", "[^&]+?");
    static final String QUALIFIERS = String.format("%s(&%s)*", QUALIFIER, QUALIFIER);
    static final Splitter.MapSplitter QUALIFIER_SPLITTER = Splitter.on((char)'&').withKeyValueSeparator('=');
    static final String SUBPATH = ".+";
    static final String SUBPATH_SEGMENT = "[^/]+";
    static final Splitter SEGMENT_SPLITTER = Splitter.on((char)'/');
    static final Pattern PURL_SCHEME_PATTERN = Pattern.compile(String.format("%s:(/)*(?<type>%s)/((?<namespace>%s)/)?(?<name>%s)(@(?<version>%s))?(\\?(?<qualifiers>%s))?(#(?<subpath>%s))?", "pkg", "[a-zA-Z][a-zA-Z\\d.+-]*", "[^@#?]+", "[^/@#?]+", ".+?", QUALIFIERS, ".+"));
    static final Pattern PURL_SCHEMELESS_PATTERN = Pattern.compile(String.format("(?<type>%s):(//)?((?<namespace>%s)/)?(?<name>%s)(@(?<version>%s))?(\\?(?<qualifiers>%s))?(#(?<subpath>%s))?", "[a-zA-Z][a-zA-Z\\d.+-]*", "[^@#?]+", "[^/@#?]+", ".+?", QUALIFIERS, ".+"));

    private PackageUrlParser() {
    }

    public static PackageUrl parse(String value) {
        Preconditions.checkNotNull((Object)value);
        Pattern pattern = value.startsWith("pkg:") ? PURL_SCHEME_PATTERN : PURL_SCHEMELESS_PATTERN;
        Matcher m = pattern.matcher(value);
        if (m.matches()) {
            return new PackageUrlBuilder().type(PackageUrlParser.parseType(m.group("type"))).namespace(PackageUrlParser.parseNamespace(m.group("namespace"))).name(PackageUrlParser.parseName(m.group("name"))).version(PackageUrlParser.parseVersion(m.group("version"))).qualifiers(PackageUrlParser.parseQualifiers(m.group("qualifiers"))).subpath(PackageUrlParser.parseSubpath(m.group("subpath"))).buildAndValidate(false);
        }
        throw new InvalidException(value);
    }

    static String parseType(String value) {
        return MoreStrings.lowerCase(value);
    }

    @Nullable
    static List<String> parseNamespace(@Nullable String value) {
        return PackageUrlParser.parseSegments(value, new String[0]);
    }

    static String parseName(String value) {
        return PercentEncoding.decode(value);
    }

    @Nullable
    static String parseVersion(@Nullable String value) {
        if (value != null) {
            return PercentEncoding.decode(value);
        }
        return null;
    }

    @Nullable
    static Map<String, String> parseQualifiers(@Nullable String value) {
        if (value == null) {
            return null;
        }
        Map pairs = QUALIFIER_SPLITTER.split((CharSequence)value);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(pairs.size());
        for (Map.Entry entry : pairs.entrySet()) {
            String v = (String)entry.getValue();
            if (v.isEmpty()) continue;
            String k = MoreStrings.lowerCase((String)entry.getKey());
            result.put(k, PercentEncoding.decode(v));
        }
        return result.isEmpty() ? null : result;
    }

    @Nullable
    static List<String> parseSubpath(@Nullable String value) {
        return PackageUrlParser.parseSegments(value, ".", "..");
    }

    @Nullable
    static List<String> parseSegments(@Nullable String value, String ... invalids) {
        if (value == null) {
            return null;
        }
        Iterable parts = SEGMENT_SPLITTER.split((CharSequence)PackageUrlParser.stripSlashes(value));
        ArrayList<String> result = new ArrayList<String>();
        for (String part : parts) {
            if (part.isEmpty()) {
                throw new EmptySegmentException(value);
            }
            if ((part = PercentEncoding.decode(part)).contains("/")) {
                throw new IllegalSegmentContentException("/", value);
            }
            String[] stringArray = invalids;
            int n = invalids.length;
            int n2 = 0;
            while (n2 < n) {
                String invalid = stringArray[n2];
                if (part.equals(invalid)) {
                    throw new IllegalSegmentContentException(invalid, value);
                }
                ++n2;
            }
            result.add(part);
        }
        return result.isEmpty() ? null : result;
    }

    private static String stripSlashes(String value) {
        if (value.charAt(0) == '/') {
            value = value.substring(1);
        }
        if (value.charAt(value.length() - 1) == '/') {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

