/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonatype.goodies.packageurl.InvalidException;
import org.sonatype.goodies.packageurl.MissingComponentException;

class PackageUrlValidator {
    private static final Pattern TYPE_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z\\d.+-]*");
    private static final Pattern NAMESPACE_SEGMENT_PATTERN = Pattern.compile("[^/]+");
    private static final Pattern NAME_PATTERN = Pattern.compile("[^/@#?]+");
    private static final Pattern VERSION_PATTERN = Pattern.compile(".+?");
    private static final Pattern QUALIFIER_KEY_PATTERN = Pattern.compile("[a-zA-Z.\\-_][a-zA-Z\\d.\\-_]*");
    private static final Pattern QUALIFIER_VALUE_PATTERN = Pattern.compile("[^&]+?");
    private static final Pattern SUBPATH_SEGMENT_PATTERN = Pattern.compile("[^/]+");

    private PackageUrlValidator() {
    }

    private static void validate(String type, Pattern pattern, String value) {
        if (!pattern.matcher(value).matches()) {
            throw new InvalidException("Invalid " + type + ": " + value);
        }
    }

    static void validateType(String value) {
        if (value == null) {
            throw new MissingComponentException("type");
        }
        PackageUrlValidator.validate("type", TYPE_PATTERN, value);
    }

    static void validateNamespace(@Nullable List<String> namespace) {
        if (namespace != null) {
            for (String segment : namespace) {
                PackageUrlValidator.validate("namespace.segment", NAMESPACE_SEGMENT_PATTERN, segment);
            }
        }
    }

    static void validateName(String value) {
        if (value == null) {
            throw new MissingComponentException("name");
        }
    }

    static void validateVersion(@Nullable String value) {
        if (value != null) {
            PackageUrlValidator.validate("version", VERSION_PATTERN, value);
        }
    }

    static void validateQualifiers(@Nullable Map<String, String> qualifiers) {
        if (qualifiers != null) {
            for (Map.Entry<String, String> entry : qualifiers.entrySet()) {
                PackageUrlValidator.validate("qualifier.key", QUALIFIER_KEY_PATTERN, entry.getKey());
            }
        }
    }

    static void validateSubpath(@Nullable List<String> subpath) {
        if (subpath != null) {
            for (String segment : subpath) {
                PackageUrlValidator.validate("subpath.segment", SUBPATH_SEGMENT_PATTERN, segment);
            }
        }
    }
}

