/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.sonatype.clm.dto.model.component.ComponentDisplayName;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import java.util.Map;
import java.util.SortedMap;

public class ComponentDisplayNameUtil {
    public static final String GENERIC_SEPARATOR = " : ";
    public static final String GAV_SEPARATOR = " : ";
    public static final String NUGET_SEPARATOR = " ";
    public static final String ANAME_SEPARATOR = " ";
    public static final String SWIFT_SEPARATOR = " ";
    public static final String TERRAFORM_SEPARATOR = " : ";
    public static final String COCOAPODS_SEPARATOR = " : ";
    public static final String CONAN_SEPARATOR = " : ";
    public static final String CARGO_SEPARATOR = " : ";
    public static final String CRAN_SEPARATOR = " : ";
    public static final String CONDA_SEPARATOR = "/";
    public static final String CONDA_SEPARATOR_TYPE = ".";
    public static final String GROUP_LABEL = "Group";
    public static final String ARTIFACT_LABEL = "Artifact";
    public static final String VERSION_LABEL = "Version";
    public static final String EXTENSION_LABEL = "Extension";
    public static final String CLASSIFIER_LABEL = "Classifier";
    public static final String ID_LABEL = "ID";
    public static final String NAME_LABEL = "Name";
    public static final String QUALIFIER_LABEL = "Qualifier";
    public static final String ARCHITECTURE_LABEL = "Architecture";
    public static final String PLATFORM_LABEL = "Platform";
    public static final String NAMESPACE_LABEL = "Namespace";
    public static final String PLAN_LABEL = "Plan";
    public static final String CHANNEL_LABEL = "Channel";
    public static final String OWNER_LABEL = "Owner";
    public static final String CONTAINER_SEPARATOR = " : ";
    public static final String TYPE_LABEL = "Type";
    public static final String SUBDIR_LABEL = "Subdir";
    public static final String BUILD_LABEL = "Build";
    public static final String COMPOSER_SEPARATOR = "/";

    private static ComponentDisplayName fromGeneric(SortedMap<String, String> coordinatesMap) {
        String name = (String)coordinatesMap.get("name");
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().setName(name).add(NAME_LABEL, name);
        if (ComponentDisplayNameUtil.isNotBlank((String)coordinatesMap.get("version"))) {
            componentDisplayName.add(" : ").add(VERSION_LABEL, (String)coordinatesMap.get("version"));
        }
        coordinatesMap.keySet().stream().filter(key -> !key.equals("name") && !key.equals("version")).forEach(key -> componentDisplayName.add(" : ").add((String)key, (String)coordinatesMap.get(key)));
        return componentDisplayName;
    }

    private static ComponentDisplayName fromGavec(String groupId, String artifactId, String version, String extension, String classifier) {
        boolean showExtension;
        if (groupId == null) {
            return null;
        }
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().setName(artifactId).add(GROUP_LABEL, groupId).add(" : ").add(ARTIFACT_LABEL, artifactId);
        boolean hasClassifier = classifier != null && !classifier.isEmpty();
        boolean bl = showExtension = extension != null && !extension.isEmpty() && (!extension.equalsIgnoreCase("jar") || hasClassifier);
        if (showExtension) {
            componentDisplayName.add(" : ").add(EXTENSION_LABEL, extension);
        } else if (hasClassifier) {
            componentDisplayName.add(" : ");
        }
        if (hasClassifier) {
            componentDisplayName.add(" : ").add(CLASSIFIER_LABEL, classifier);
        }
        return componentDisplayName.add(" : ").add(VERSION_LABEL, version);
    }

    private static ComponentDisplayName fromNuGet(String packageId, String version) {
        return new ComponentDisplayName().setName(packageId).add(ID_LABEL, packageId).add(" ").add(VERSION_LABEL, version);
    }

    private static ComponentDisplayName fromAname(String name, String version, String qualifier) {
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name).add(NAME_LABEL, name);
        if (qualifier != null && !qualifier.isEmpty()) {
            displayName.add(" ").add("(").add(QUALIFIER_LABEL, qualifier).add(")");
        }
        displayName.add(" ").add(VERSION_LABEL, version);
        return displayName;
    }

    private static ComponentDisplayName fromPypi(String name, String version, String qualifier, String extension) {
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name).add(NAME_LABEL, name);
        if (qualifier != null && !qualifier.isEmpty()) {
            displayName.add(" (").add(QUALIFIER_LABEL, qualifier).add(")");
        }
        displayName.add(" ").add(VERSION_LABEL, version);
        if (extension != null && !extension.isEmpty()) {
            displayName.add(" (.").add(EXTENSION_LABEL, extension).add(")");
        }
        return displayName;
    }

    private static ComponentDisplayName fromRpm(String name, String version, String architecture) {
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name).add(NAME_LABEL, name).add("-").add(VERSION_LABEL, version);
        if (architecture != null && !architecture.isEmpty()) {
            displayName.add(CONDA_SEPARATOR_TYPE).add(ARCHITECTURE_LABEL, architecture);
        }
        return displayName;
    }

    private static ComponentDisplayName fromRubyGems(String name, String version, String platform) {
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name).add(NAME_LABEL, name);
        if (platform != null && !"".equals(platform) && !"ruby".equals(platform)) {
            displayName.add(" (").add(PLATFORM_LABEL, platform).add(") ");
        } else {
            displayName.add(" ");
        }
        displayName.add(VERSION_LABEL, version);
        return displayName;
    }

    private static ComponentDisplayName fromGolang(String name, String version) {
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name).add(NAME_LABEL, name).add(" ").add(VERSION_LABEL, version);
        return displayName;
    }

    private static ComponentDisplayName fromPecoff(String namespace, String name, String version) {
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name);
        if (namespace != null && !namespace.isEmpty()) {
            displayName.add(NAMESPACE_LABEL, namespace).add(" ");
        }
        displayName.add(NAME_LABEL, name).add(" ").add(VERSION_LABEL, version);
        return displayName;
    }

    private static ComponentDisplayName fromSwift(String name, String version) {
        return new ComponentDisplayName().setName(name).add(NAME_LABEL, name).add(" ").add(VERSION_LABEL, version);
    }

    private static ComponentDisplayName fromTerraform(String plan, String name, String version) {
        return new ComponentDisplayName().setName(name).add(PLAN_LABEL, plan).add(" : ").add(NAME_LABEL, name).add(" : ").add(VERSION_LABEL, version);
    }

    private static ComponentDisplayName fromCocoapods(String name, String version) {
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name);
        return displayName.add(NAME_LABEL, name).add(" : ").add(VERSION_LABEL, version);
    }

    private static ComponentDisplayName fromContainer(String name, String nameSpace, String version) {
        return new ComponentDisplayName().setName(name).add(NAMESPACE_LABEL, nameSpace).add(" : ").add(NAME_LABEL, name).add(" : ").add(VERSION_LABEL, version);
    }

    private static ComponentDisplayName fromIac(String name) {
        return new ComponentDisplayName().setName(name).add(NAME_LABEL, name);
    }

    private static ComponentDisplayName fromConan(ComponentIdentifier componentIdentifier) {
        String channel;
        String name = componentIdentifier.get("name");
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name);
        displayName.add(NAME_LABEL, name).add(" : ").add(VERSION_LABEL, componentIdentifier.get("version"));
        String owner = componentIdentifier.get("owner");
        if (owner != null && !owner.isEmpty()) {
            displayName.add(" : ").add(OWNER_LABEL, owner);
        }
        if ((channel = componentIdentifier.get("channel")) != null && !channel.isEmpty()) {
            displayName.add(" : ").add(CHANNEL_LABEL, channel);
        }
        return displayName;
    }

    private static ComponentDisplayName fromCran(ComponentIdentifier componentIdentifier) {
        String name = componentIdentifier.get("name");
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name);
        displayName.add(NAME_LABEL, name).add(" : ").add(VERSION_LABEL, componentIdentifier.get("version"));
        String type = componentIdentifier.get("type");
        if (type != null && !type.isEmpty()) {
            displayName.add(" : ").add(TYPE_LABEL, type);
        }
        return displayName;
    }

    private static ComponentDisplayName fromCargo(ComponentIdentifier componentIdentifier) {
        String name = componentIdentifier.get("name");
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name);
        displayName.add(NAME_LABEL, name).add(" : ").add(VERSION_LABEL, componentIdentifier.get("version"));
        String type = componentIdentifier.get("type");
        if (type != null && !type.isEmpty()) {
            displayName.add(" : ").add(TYPE_LABEL, type);
        }
        return displayName;
    }

    private static ComponentDisplayName fromConda(ComponentIdentifier componentIdentifier) {
        String type;
        String subdir;
        String name = componentIdentifier.get("name");
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name);
        String channel = componentIdentifier.get("channel");
        if (ComponentDisplayNameUtil.isNotBlank(channel)) {
            displayName.add(CHANNEL_LABEL, channel);
        }
        if (ComponentDisplayNameUtil.isNotBlank(subdir = componentIdentifier.get("subdir"))) {
            if (displayName.parts != null) {
                displayName.add("/");
            }
            displayName.add(SUBDIR_LABEL, subdir);
        }
        if (displayName.parts != null) {
            displayName.add("/");
        }
        displayName.add(NAME_LABEL, name).add("/").add(VERSION_LABEL, componentIdentifier.get("version"));
        String build = componentIdentifier.get("build");
        if (ComponentDisplayNameUtil.isNotBlank(build)) {
            displayName.add("/").add(BUILD_LABEL, build);
        }
        if (ComponentDisplayNameUtil.isNotBlank(type = componentIdentifier.get("type"))) {
            displayName.add(CONDA_SEPARATOR_TYPE).add(TYPE_LABEL, type);
        }
        return displayName;
    }

    private static ComponentDisplayName fromComposer(ComponentIdentifier componentIdentifier) {
        String namespace = componentIdentifier.get("namespace");
        String name = componentIdentifier.get("name");
        ComponentDisplayName displayName = new ComponentDisplayName().setName(name);
        displayName.add(NAMESPACE_LABEL, namespace).add("/").add(NAME_LABEL, name).add("/").add(VERSION_LABEL, componentIdentifier.get("version"));
        return displayName;
    }

    private static boolean isNotBlank(String coordinate) {
        return coordinate != null && !coordinate.isEmpty();
    }

    public static ComponentDisplayName fromIdentifier(ComponentIdentifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.isGeneric()) {
            return ComponentDisplayNameUtil.fromGeneric(identifier.getCoordinates());
        }
        if (identifier.isMaven()) {
            return ComponentDisplayNameUtil.fromGavec(identifier.get("groupId"), identifier.get("artifactId"), identifier.get("version"), identifier.get("extension"), identifier.get("classifier"));
        }
        if ("nuget".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromNuGet(identifier.get("packageId"), identifier.get("version"));
        }
        if ("a-name".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromAname(identifier.get("name"), identifier.get("version"), identifier.get("qualifier"));
        }
        if ("pypi".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromPypi(identifier.get("name"), identifier.get("version"), identifier.get("qualifier"), identifier.get("extension"));
        }
        if ("rpm".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromRpm(identifier.get("name"), identifier.get("version"), identifier.get("architecture"));
        }
        if ("gem".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromRubyGems(identifier.get("name"), identifier.get("version"), identifier.get("platform"));
        }
        if ("golang".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromGolang(identifier.get("name"), identifier.get("version"));
        }
        if ("pecoff".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromPecoff(identifier.get("namespace"), identifier.get("name"), identifier.get("version"));
        }
        if ("swift".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromSwift(identifier.get("name"), identifier.get("version"));
        }
        if ("terraform".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromTerraform(identifier.get("plan"), identifier.get("name"), identifier.get("version"));
        }
        if ("cocoapods".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromCocoapods(identifier.get("name"), identifier.get("version"));
        }
        if ("conan".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromConan(identifier);
        }
        if ("container".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromContainer(identifier.get("name"), identifier.get("namespace"), identifier.get("version"));
        }
        if ("iac".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromIac(identifier.get("name"));
        }
        if ("cargo".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromCargo(identifier);
        }
        if ("cran".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromCran(identifier);
        }
        if ("conda".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromConda(identifier);
        }
        if ("composer".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromComposer(identifier);
        }
        ComponentDisplayName name = new ComponentDisplayName();
        boolean first = true;
        for (Map.Entry<String, String> entry : identifier.getCoordinates().entrySet()) {
            if (!first) {
                name.add(" : ");
            }
            first = false;
            name.add(entry.getKey(), entry.getValue());
        }
        return name;
    }
}

