/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.client;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.clm.dto.model.ScanReceipt;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationPollingResult;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationResult;
import com.sonatype.clm.dto.model.policy.Stage;
import com.sonatype.clm.dto.model.signature.ComponentWithSignaturesList;
import com.sonatype.clm.dto.model.signature.VulnerabilitySignatureAnalysisDTO;
import com.sonatype.insight.brain.client.ConfigurationClient;
import com.sonatype.insight.brain.client.PolicyClient;
import com.sonatype.insight.brain.client.ReportClient;
import com.sonatype.insight.brain.client.ScanClient;
import com.sonatype.insight.brain.client.SourceControlClient;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.scan.model.ClientScanResult;
import com.sonatype.insight.scan.model.ClientScanType;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.inject.Named;
import org.slf4j.Logger;

@Named
public class RestClientFactory {
    public RestClient newRestCIClient(HttpClientUtils.Configuration config) {
        return this.newRestCIClient(config, null);
    }

    public RestClient newRestCIClient(HttpClientUtils.Configuration config, Logger logger) {
        return new RestCIClient(config, logger);
    }

    public RestClient newRestCLIClient(HttpClientUtils.Configuration config) {
        return new RestCLIClient(config);
    }

    public static abstract class RestClient {
        protected final HttpClientUtils.Configuration config;

        protected RestClient(HttpClientUtils.Configuration config) {
            this.config = config;
        }

        public abstract ScanReceipt uploadScan(String var1, File var2, ClientScanType var3) throws IOException;

        public boolean verifyOrCreateApplication(String applicationPublicId, String organizationId) throws IOException {
            return new ConfigurationClient(this.config).verifyOrCreateApplication(applicationPublicId, organizationId);
        }

        public boolean verifyOrCreateApplication(String applicationPublicId) throws IOException {
            return new ConfigurationClient(this.config).verifyOrCreateApplication(applicationPublicId);
        }

        public ProprietaryConfig getProprietaryConfigForApplicationEvaluation(String applicationPublicId) throws IOException {
            return new ConfigurationClient(this.config).getProprietaryConfigForApplicationEvaluation(applicationPublicId);
        }

        public ProprietaryConfig getProprietaryConfigForComponentEvaluation(String applicationPublicId) throws IOException {
            return new ConfigurationClient(this.config).getProprietaryConfigForComponentEvaluation(applicationPublicId);
        }

        public abstract PolicyEvaluationPollingResult evaluatePolicy(String var1, String var2, ClientScanResult var3, ClientScanType var4) throws IOException;

        public void saveReportBundle(String appId, String scanId, File bundleFile) throws IOException {
            new ReportClient(this.config, appId, scanId).downloadBundle(bundleFile);
        }

        public void saveResults(String appId, File resultFile, ScanReceipt receipt, PolicyEvaluationResult eval, String outcome) throws IOException {
            new ScanClient(this.config, appId).saveResultData(resultFile, receipt, eval, outcome);
        }

        public void saveErrorData(String appId, File resultFile, String errorMessage, boolean isSystemError) throws IOException {
            new ScanClient(this.config, appId).saveErrorData(resultFile, errorMessage, isSystemError);
        }

        public void saveErrorData(String appId, File resultFile, String errorMessage, boolean isSystemError, boolean isScanningError) throws IOException {
            new ScanClient(this.config, appId).saveErrorData(resultFile, errorMessage, isSystemError, isScanningError);
        }

        public void validateServerVersion(String minimalServerVersionRequiredAsString) throws IOException {
            new ConfigurationClient(this.config).validateServerVersion(minimalServerVersionRequiredAsString);
        }

        public void addOrUpdateSourceControlRecord(String publicId, String repositoryUrl) throws IOException {
            new SourceControlClient(this.config).addOrUpdateSourceControlRecord(publicId, repositoryUrl);
        }

        public Set<String> getLicensedFeatures() throws IOException {
            return new ConfigurationClient(this.config).getLicensedFeatures();
        }

        public ComponentWithSignaturesList getVulnerableComponentsWithSignatures(String applicationId, String scanId) throws IOException {
            return new ScanClient(this.config, applicationId).getVulnerableComponentsWithSignatures(scanId);
        }

        public PolicyEvaluationResult importReachabilityAnalysis(String applicationId, String scanId, VulnerabilitySignatureAnalysisDTO analysisDTO) throws IOException {
            return new PolicyClient(this.config, applicationId).importReachabilityAnalysis(scanId, analysisDTO);
        }
    }

    public static class RestCIClient
    extends RestClient {
        private final Logger logger;

        RestCIClient(HttpClientUtils.Configuration config, Logger logger) {
            super(config);
            this.logger = logger;
        }

        @Override
        public PolicyEvaluationPollingResult evaluatePolicy(String appId, String stageId, ClientScanResult clientScanResult, ClientScanType clientScanType) throws IOException {
            return new PolicyClient(this.config, appId, this.logger).evaluateCI(clientScanResult, new Stage(stageId));
        }

        @Override
        public ScanReceipt uploadScan(String appId, File scanFile, ClientScanType clientScanType) {
            throw new UnsupportedOperationException("Uploading a scan file is not supported.");
        }
    }

    public static class RestCLIClient
    extends RestClient {
        RestCLIClient(HttpClientUtils.Configuration config) {
            super(config);
        }

        @Override
        public PolicyEvaluationPollingResult evaluatePolicy(String appId, String stageId, ClientScanResult clientScanResult, ClientScanType clientScanType) throws IOException {
            return new PolicyClient(this.config, appId).evaluateCLI(clientScanResult, clientScanType, new Stage(stageId));
        }

        @Override
        public ScanReceipt uploadScan(String appId, File scanFile, ClientScanType clientScanType) throws IOException {
            return new ScanClient(this.config, appId).uploadCLIScan(scanFile, clientScanType);
        }
    }
}

