/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.brain.common.io;

import java.io.File;
import java.io.IOException;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.codehaus.plexus.util.FileUtils;

@Named
public class FileCleaner {
    private static final Logger log = LoggerFactory.getLogger(FileCleaner.class);

    public void delete(File file) throws FileDeletionException {
        if (file != null && file.exists()) {
            long start = System.currentTimeMillis();
            try {
                FileUtils.forceDelete(file);
            }
            catch (IOException e) {
                throw new FileDeletionException(file, e);
            }
            long duration = System.currentTimeMillis() - start;
            if (duration > 500L) {
                log.debug("Deleted file/dir '{}' in {} ms.", (Object)file.getAbsolutePath(), (Object)duration);
            }
        }
    }

    public static class FileDeletionException
    extends IOException {
        private static final long serialVersionUID = 6322158674244100349L;

        public FileDeletionException(File file, Exception exception) {
            super("File can not be deleted: " + file.getAbsolutePath(), exception);
        }
    }
}

