/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.util.Args;

class InMemoryAuthCache
implements AuthCache {
    private final Map<HttpHost, AuthScheme> map = new ConcurrentHashMap<HttpHost, AuthScheme>();
    private final SchemePortResolver schemePortResolver = DefaultSchemePortResolver.INSTANCE;

    InMemoryAuthCache() {
    }

    public void put(HttpHost host, AuthScheme authScheme) {
        Args.notNull((Object)host, (String)"HTTP host");
        if (authScheme == null) {
            return;
        }
        this.map.put(this.getKey(host), authScheme);
    }

    public AuthScheme get(HttpHost host) {
        Args.notNull((Object)host, (String)"HTTP host");
        return this.map.get(this.getKey(host));
    }

    public void remove(HttpHost host) {
        Args.notNull((Object)host, (String)"HTTP host");
        this.map.remove(this.getKey(host));
    }

    public void clear() {
        this.map.clear();
    }

    protected HttpHost getKey(HttpHost host) {
        if (host.getPort() <= 0) {
            int port;
            try {
                port = this.schemePortResolver.resolve(host);
            }
            catch (UnsupportedSchemeException ignore) {
                return host;
            }
            return new HttpHost(host.getHostName(), port, host.getSchemeName());
        }
        return host;
    }
}

