/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.client.utils;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserAgentUtils {
    private static final Logger log = LoggerFactory.getLogger(UserAgentUtils.class);
    private static final String PROPS_RESOURCE_OLD = "/com/sonatype/insight/scan/scanner.properties";
    private static final String PROPS_RESOURCE_NEW = "/com/sonatype/insight/client.properties";

    private UserAgentUtils() {
    }

    public static String getDefaultUserAgent(String clientName) {
        return UserAgentUtils.getDefaultUserAgent(clientName, UserAgentUtils.getClientVersion());
    }

    public static String getDefaultUserAgent(String clientName, String clientVersion) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(clientName);
        buffer.append("/");
        buffer.append(clientVersion);
        buffer.append(" (");
        buffer.append("Java ").append(System.getProperty("java.version"));
        buffer.append("; ");
        buffer.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version"));
        String hostSystem = UserAgentUtils.getHostSystem();
        if (UserAgentUtils.isNotEmpty(hostSystem)) {
            buffer.append("; ");
            buffer.append(hostSystem);
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static String getDefaultUserAgent() {
        return UserAgentUtils.getDefaultUserAgent(UserAgentUtils.getClientName());
    }

    public static String getClientName() {
        String customClientName = System.getenv("SONATYPE_INTERNAL_CLIENT_NAME");
        if (UserAgentUtils.isNotEmpty(customClientName)) {
            return customClientName;
        }
        return UserAgentUtils.loadClientProperties().getProperty("userAgent", "unknown-tool");
    }

    public static String getClientVersion() {
        String customClientVersion = System.getenv("SONATYPE_INTERNAL_CLIENT_VERSION");
        if (UserAgentUtils.isNotEmpty(customClientVersion)) {
            return customClientVersion;
        }
        return UserAgentUtils.loadClientProperties().getProperty("version", "unknown-version");
    }

    public static String getHostSystem() {
        return System.getenv("SONATYPE_INTERNAL_HOST_SYSTEM");
    }

    private static boolean isNotEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    private static Properties loadClientProperties() {
        Properties props = new Properties();
        String propertiesResourceName = PROPS_RESOURCE_NEW;
        InputStream is = UserAgentUtils.class.getResourceAsStream(propertiesResourceName);
        if (is == null) {
            propertiesResourceName = PROPS_RESOURCE_OLD;
            is = UserAgentUtils.class.getResourceAsStream(propertiesResourceName);
        }
        if (is == null) {
            log.debug("Did not find properties resource with user agent info at {} or {}, using defaults", (Object)PROPS_RESOURCE_OLD, (Object)PROPS_RESOURCE_NEW);
            return props;
        }
        try {
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load properties resource: " + propertiesResourceName, e);
        }
        return props;
    }
}

