/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.rest;

import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.client.utils.SimpleAuthentication;
import org.apache.http.impl.client.HttpClientBuilder;

public class RestClientConfiguration {
    private final HttpClientUtils.Configuration config = new HttpClientUtils.Configuration();

    HttpClientUtils.Configuration getConfig() {
        return this.config;
    }

    public String getServerUrl() {
        return this.config.getServerUrl();
    }

    public RestClientConfiguration setServerUrl(String serverUrl) {
        this.config.setServerUrl(serverUrl);
        return this;
    }

    public String getProxyHost() {
        return this.config.getProxyHost();
    }

    public RestClientConfiguration setProxyHost(String proxyHost) {
        this.config.setProxyHost(proxyHost);
        return this;
    }

    public int getProxyPort() {
        return this.config.getProxyPort();
    }

    public RestClientConfiguration setProxyPort(int proxyPort) {
        this.config.setProxyPort(proxyPort);
        return this;
    }

    public RestClientConfiguration setProxy(String proxy) {
        this.config.setProxy(proxy);
        return this;
    }

    public RestClientConfiguration setProxyAuth(String username, String password, String ntlmDomain, String ntlmWorkstation) {
        SimpleAuthentication auth = new SimpleAuthentication();
        auth.setUsername(username);
        auth.setPassword(password);
        auth.setNtlmDomain(ntlmDomain);
        auth.setNtlmWorkstation(ntlmWorkstation);
        this.config.setProxyAuth(auth);
        return this;
    }

    public RestClientConfiguration setHttpClientProvider(final HttpClientProvider httpClientProvider) {
        this.config.setHttpClientProvider(new HttpClientUtils.HttpClientProvider(){

            @Override
            public HttpClientBuilder create(HttpClientUtils.Configuration config) {
                return httpClientProvider.createHttpClient(RestClientConfiguration.this);
            }
        });
        return this;
    }

    public static interface HttpClientProvider {
        public HttpClientBuilder createHttpClient(RestClientConfiguration var1);
    }
}

