/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.rm.rest;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.clm.dto.model.Resource;
import com.sonatype.clm.dto.model.ScanReceipt;
import com.sonatype.clm.dto.model.application.ApplicationSummaryList;
import com.sonatype.clm.dto.model.component.FirewallIgnorePatterns;
import com.sonatype.clm.dto.model.component.ProprietaryComponentNames;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.clm.dto.model.component.RepositoryComponentPathnames;
import com.sonatype.clm.dto.model.component.UnquarantinedComponentList;
import com.sonatype.clm.dto.model.policy.PolicyEvaluationResult;
import com.sonatype.clm.dto.model.policy.RepositoryPolicyEvaluationSummary;
import com.sonatype.clm.dto.model.repository.QuarantinedComponentReport;
import com.sonatype.clm.dto.model.repository.migration.MigrationDetails;
import com.sonatype.insight.brain.client.ConfigurationClient;
import com.sonatype.insight.brain.client.FirewallClient;
import com.sonatype.insight.brain.client.FirewallMigrationClient;
import com.sonatype.insight.brain.client.PolicyClient;
import com.sonatype.insight.brain.client.ResourceClient;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.rm.rest.HttpException;
import com.sonatype.insight.rm.rest.RepositoryManagerType;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.insight.rm.rest.RestClientConfiguration;
import com.sonatype.insight.rm.rest.Stage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.utils.URIBuilder;

public class RestClientFactory {
    public RestClient.Base forConfiguration(RestClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("REST client configuration missing");
        }
        return new BaseClient(config.getConfig());
    }

    ConfigurationClient newConfigurationClient(HttpClientUtils.Configuration config) {
        return new ConfigurationClient(config);
    }

    FirewallClient newFirewallClient(HttpClientUtils.Configuration config, String repositoryManagerInstanceId, String repositoryPublicId, RepositoryManagerType repositoryManagerType) {
        return new FirewallClient(config, repositoryManagerInstanceId, repositoryPublicId, repositoryManagerType.resourcePath);
    }

    FirewallMigrationClient newFirewallMigrationClient(HttpClientUtils.Configuration config) {
        return new FirewallMigrationClient(config);
    }

    PolicyClient newPolicyClient(HttpClientUtils.Configuration configuration, String appId) {
        return new PolicyClient(configuration, appId);
    }

    private class FirewallMigrationSpecificClient
    extends BaseClient
    implements RestClient.FirewallMigration {
        FirewallMigrationSpecificClient(HttpClientUtils.Configuration config) {
            super(config);
        }

        @Override
        public void verifyMigrationSupport(String protocolVersion) throws IOException {
            RestClientFactory.this.newFirewallMigrationClient(this.config).verifyMigrationSupport(protocolVersion);
        }

        @Override
        public void migrateRepositoryHistory(String sourceRepositoryManagerInstanceId, String sourceRepositoryPublicId, String targetRepositoryManagerInstanceId, String targetRepositoryPublicId) throws IOException {
            RestClientFactory.this.newFirewallMigrationClient(this.config).migrateRepositoryHistory(sourceRepositoryManagerInstanceId, sourceRepositoryPublicId, targetRepositoryManagerInstanceId, targetRepositoryPublicId);
        }

        @Override
        public MigrationDetails getRepositoryMigrationState(String targetRepositoryManagerInstanceId, String targetRepositoryPublicId) throws IOException {
            return RestClientFactory.this.newFirewallMigrationClient(this.config).getRepositoryMigrationState(targetRepositoryManagerInstanceId, targetRepositoryPublicId);
        }
    }

    private class ScanSpecificClient
    extends BaseClient
    implements RestClient.Scan {
        private final String appId;
        private final File scanFile;

        public ScanSpecificClient(HttpClientUtils.Configuration config, String appId, File scanFile) {
            super(config);
            this.appId = appId;
            this.scanFile = scanFile;
        }

        @Override
        public PolicyEvaluationResult evaluatePolicies(Stage stage) throws IOException {
            return RestClientFactory.this.newPolicyClient(this.config, this.appId).evaluateRepoMan(this.scanFile, this.getStage(stage)).getResult();
        }

        @Override
        public ScanReceipt evaluatePoliciesWithReportId(Stage stage) throws IOException {
            return RestClientFactory.this.newPolicyClient(this.config, this.appId).evaluateRepoMan(this.scanFile, this.getStage(stage)).getScanReceipt();
        }

        private com.sonatype.clm.dto.model.policy.Stage getStage(Stage stage) {
            com.sonatype.clm.dto.model.policy.Stage st;
            if (stage == null) {
                throw new IllegalArgumentException("stage missing");
            }
            switch (stage) {
                case CLOSE_REPOSITORY: {
                    st = new com.sonatype.clm.dto.model.policy.Stage("stage-release");
                    break;
                }
                case RELEASE_REPOSITORY: {
                    st = new com.sonatype.clm.dto.model.policy.Stage("release");
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported stage " + (Object)((Object)stage));
                }
            }
            return st;
        }
    }

    private class RepositorySpecificClient
    extends BaseClient
    implements RestClient.Repository {
        private final String repositoryManagerInstanceId;
        private final String repositoryPublicId;
        private final RepositoryManagerType repositoryManagerType;

        public RepositorySpecificClient(HttpClientUtils.Configuration config, String repositoryManagerInstanceId, String repositoryPublicId, RepositoryManagerType repositoryManagerType) {
            super(config);
            this.repositoryManagerInstanceId = repositoryManagerInstanceId;
            this.repositoryPublicId = repositoryPublicId;
            this.repositoryManagerType = repositoryManagerType;
        }

        @Override
        public void setEnabled(boolean enabled) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).setEnabled(enabled);
        }

        @Override
        public void setQuarantine(boolean enabled) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).setQuarantine(enabled);
        }

        @Override
        public void evaluateComponents(RepositoryComponentEvaluationDataRequestList componentEvaluationDataRequestList) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).evaluateComponents(componentEvaluationDataRequestList);
        }

        @Override
        public RepositoryComponentEvaluationDataList evaluateComponentsAdhoc(RepositoryComponentEvaluationDataRequestList componentEvaluationDataRequestList) throws IOException {
            return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).evaluateComponentsAdhoc(componentEvaluationDataRequestList);
        }

        @Override
        public RepositoryComponentEvaluationDataList evaluateComponentWithQuarantine(RepositoryComponentEvaluationDataRequestList repositoryComponentEvaluationDataRequestList) throws IOException {
            return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).evaluateComponentWithQuarantine(repositoryComponentEvaluationDataRequestList);
        }

        @Override
        public RepositoryPolicyEvaluationSummary getPolicyEvaluationSummary() throws IOException {
            return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).getPolicyEvaluationSummary();
        }

        @Override
        public void removeComponent(String pathname) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).removeComponent(pathname);
        }

        @Override
        public UnquarantinedComponentList getUnquarantinedComponents(long sinceUtcTimestamp) throws IOException {
            try {
                return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).getUnquarantinedComponents(sinceUtcTimestamp);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 405) {
                    throw new UnsupportedOperationException("IQ Server doesn't support unquarantined component updates, upgrade it to version 1.20, or newer, to support it.", e);
                }
                throw e;
            }
        }

        @Override
        public void addProprietaryComponentNames(ProprietaryComponentNames proprietaryComponentNames) throws IOException {
            try {
                RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).addProprietaryComponentNames(proprietaryComponentNames);
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 404) {
                    throw new UnsupportedOperationException("IQ Server doesn't support cataloging proprietary component names, upgrade it to version 106, or newer, to support it.", e);
                }
                throw this.handleError((IOException)((Object)e));
            }
        }

        @Override
        public QuarantinedComponentReport getQuarantinedComponentReport(String pathname) throws IOException {
            return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).getQuarantinedComponentReport(pathname);
        }

        @Override
        public RepositoryComponentEvaluationDataList evaluateComponentMetadata(RepositoryComponentEvaluationDataRequestList repositoryComponentEvaluationDataRequestList) throws IOException {
            return RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).evaluateComponentMetadata(repositoryComponentEvaluationDataRequestList);
        }

        @Override
        public void removeExtraComponents(RepositoryComponentPathnames repositoryComponentPathnames) throws IOException {
            RestClientFactory.this.newFirewallClient(this.config, this.repositoryManagerInstanceId, this.repositoryPublicId, this.repositoryManagerType).removeExtraComponents(repositoryComponentPathnames);
        }
    }

    private class BaseClient
    implements RestClient.Base {
        protected final HttpClientUtils.Configuration config;

        public BaseClient(HttpClientUtils.Configuration config) {
            this.config = config;
        }

        @Override
        public void validateConfiguration() throws IOException {
            try {
                RestClientFactory.this.newConfigurationClient(this.config).validateConfiguration();
            }
            catch (IOException e) {
                throw this.handleError(e);
            }
        }

        @Override
        public void validateServerVersion(String version) throws IOException {
            try {
                RestClientFactory.this.newConfigurationClient(this.config).validateServerVersion(version);
            }
            catch (IOException e) {
                throw this.handleError(e);
            }
        }

        @Override
        public ApplicationSummaryList getApplicationsForApplicationEvaluation() throws IOException {
            try {
                return RestClientFactory.this.newConfigurationClient(this.config).getApplicationsForApplicationEvaluation();
            }
            catch (IOException e) {
                throw this.handleError(e);
            }
        }

        @Override
        public RestClient.Scan forApplicationScan(String appId, File scanFile) {
            return new ScanSpecificClient(this.config, appId, scanFile);
        }

        protected IOException handleError(IOException e) {
            if (e instanceof HttpResponseException) {
                HttpResponseException re = (HttpResponseException)((Object)e);
                return new HttpException(re.getStatusCode(), re.getMessage(), re);
            }
            return e;
        }

        @Override
        public Resource getResource(String path) throws IOException, URISyntaxException {
            return this.getResource(path, Collections.emptyMap());
        }

        @Override
        public Resource getResource(String path, Map<String, String[]> params) throws IOException, URISyntaxException {
            URIBuilder builder = new URIBuilder();
            builder.setPath(path);
            for (Map.Entry<String, String[]> param : params.entrySet()) {
                for (String value : param.getValue()) {
                    builder.addParameter(param.getKey(), value);
                }
            }
            return new ResourceClient(this.config).getResource(builder.build().toString());
        }

        @Override
        public RestClient.Repository forRepository(String repositoryManagerInstanceId, String repositoryPublicId, RepositoryManagerType repositoryManagerType) {
            return new RepositorySpecificClient(this.config, repositoryManagerInstanceId, repositoryPublicId, repositoryManagerType);
        }

        @Override
        public RestClient.FirewallMigration forFirewallMigration() {
            return new FirewallMigrationSpecificClient(this.config);
        }

        @Override
        public ProprietaryConfig getProprietaryConfigForApplicationEvaluation(String applicationPublicId) throws IOException {
            try {
                return RestClientFactory.this.newConfigurationClient(this.config).getProprietaryConfigForApplicationEvaluation(applicationPublicId);
            }
            catch (IOException e) {
                throw this.handleError(e);
            }
        }

        @Override
        public FirewallIgnorePatterns getFirewallIgnorePatterns() throws IOException {
            try {
                return RestClientFactory.this.newConfigurationClient(this.config).getFirewallIgnorePatterns();
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 404) {
                    throw new UnsupportedOperationException("IQ Server doesn't support firewall ignore patterns, upgrade it to version 1.35, or newer, to support it.", e);
                }
                throw this.handleError((IOException)((Object)e));
            }
        }
    }
}

